/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.service;

import com.google.common.io.Resources;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchOperator;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchService;
import org.gcube.opensearch.opensearchdatasource.service.helpers.CacheRefresher;
import org.gcube.opensearch.opensearchdatasource.service.helpers.OpenSearchDataSourceConfig;
import org.gcube.rest.opensearch.common.discover.OpenSearchDiscovererAPI;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceContext {
    static final Logger logger = LoggerFactory.getLogger(OpenSearchService.class);
    private final OpenSearchOperator operator;
    private final OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer;

    public ServiceContext(OpenSearchOperator operator, OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer) {
        this.operator = operator;
        this.discoverer = discoverer;
    }

    public void initialize() {
        try {
            Map properties = ServiceContext.readProperties();
            String hostname = (String)properties.get("hostname");
            String scope = (String)properties.get("scope");
            logger.debug("Now in resource home onInitialisation");
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(hostname, new ArrayList(), true));
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
            logger.debug("Connection manager for gRS2 Initialized");
            Boolean useRR = true;
            try {
                useRR = Boolean.valueOf((String)properties.get("useRRAdaptor"));
            }
            catch (Exception e) {
                logger.warn("error parsing useRR property", (Throwable)e);
            }
            if (useRR.booleanValue()) {
                ResourceRegistry.startBridging();
            }
            CacheRefresher refresher = null;
            OpenSearchDataSourceConfig config = new OpenSearchDataSourceConfig();
            try {
                config.initFromPropertiesFile();
            }
            catch (Exception e) {
                logger.warn("error while reading from properties file", (Throwable)e);
                config = null;
            }
            if (config != null) {
                logger.debug("OpenSearch DataSource Config:\n   clearCacheOnStartup: " + config.getClearCacheOnStartup() + "\n   cacheRefreshIntervalMillis: " + config.getCacheRefreshIntervalMillis());
                refresher = new CacheRefresher(config.getCacheRefreshIntervalMillis().longValue(), this.operator, this.discoverer, hostname, scope);
            } else {
                refresher = new CacheRefresher(0L, this.operator, this.discoverer, hostname, scope);
            }
            Thread cacheRefresher = new Thread((Runnable)refresher);
            cacheRefresher.setDaemon(true);
            cacheRefresher.start();
        }
        catch (Exception e) {
            logger.error("Could not initialize Information System", (Throwable)e);
        }
    }

    private static Map<String, String> readProperties() throws FileNotFoundException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            prop.load(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
        for (String key : prop.stringPropertyNames()) {
            String value = prop.getProperty(key);
            if (value == null) continue;
            map.put(key, value);
        }
        logger.info("properties read : " + map);
        return map;
    }
}

