/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.processor;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gcube.opensearch.opensearchdatasource.processor.GCQLNodeAnnotation;
import org.gcube.opensearch.opensearchdatasource.processor.GcqlProcessor;
import org.gcube.opensearch.opensearchdatasource.processor.GcqlQueryContainer;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlCollectionQuery;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlProcessor;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlQueryContainer;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLProxNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenSearchGcqlProcessor
extends GcqlProcessor {
    private static Logger logger = LoggerFactory.getLogger((String)OpenSearchGcqlProcessor.class.getName());
    private Map<String, String> projectedFields = new LinkedHashMap();
    private Map<String, String> searchableExpressions = new HashMap();
    private String collection = null;
    private String dataSourceLocator = null;
    private List<String> fields = null;
    private GCQLNode parsedQuery = null;
    private GCQLNodeAnnotation queryAnnotation = null;
    private OpenSearchGcqlQueryContainer queryContainer = new OpenSearchGcqlQueryContainer(new HashMap());
    private boolean useRR;

    public boolean isUseRR() {
        return this.useRR;
    }

    public void setUseRR(boolean useRR) {
        this.useRR = useRR;
    }

    public void setCollection(String collection) {
        this.collection = collection;
        this.queryContainer.queries.put(collection, new HashMap());
        ((HashMap)this.queryContainer.queries.get(collection)).put("*", new ArrayList());
        ((ArrayList)((HashMap)this.queryContainer.queries.get(collection)).get("*")).add(new OpenSearchGcqlCollectionQuery());
    }

    public String getCollection() {
        return this.collection;
    }

    public void setDataSourceLocator(String dataSourceLocator) {
        this.dataSourceLocator = dataSourceLocator;
    }

    public void setAnnotationTree(GCQLNodeAnnotation annotationTree) {
        this.queryAnnotation = annotationTree;
    }

    public void setFields(List<String> fields) {
        this.fields = new ArrayList();
        this.fields.addAll(fields);
    }

    public Map<String, String> getProjectedFields() {
        return this.projectedFields;
    }

    public GCQLNode parseQuery(String gCQLQuery) {
        this.parsedQuery = GCQLQueryTreeManager.parseGCQLString((String)gCQLQuery);
        return this.parsedQuery;
    }

    public GcqlQueryContainer processQuery(List<String> presentableFields, List<String> searchableFields) throws Exception {
        this.presentableFields = presentableFields;
        this.searchableFields = searchableFields;
        String openSearchQuery = this.processNode(this.parsedQuery, this.queryAnnotation).trim();
        logger.info("Processed OpenSearch query: " + openSearchQuery);
        return this.queryContainer;
    }

    private String processNode(GCQLNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node, nodeAnnotation);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node, nodeAnnotation);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node, nodeAnnotation);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node, nodeAnnotation);
        }
        if (node instanceof GCQLProxNode) {
            return this.processNode((GCQLProxNode)node, nodeAnnotation);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node, nodeAnnotation);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    private String processNode(GCQLProjectNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        if (node.getProjectIndexes().size() == 1 && ((ModifierSet)node.getProjectIndexes().get(0)).getBase().equals("*")) {
            logger.info("got wildcard. will use all the fields : " + this.fields);
            logger.info("or presentable fields ?               : " + this.presentableFields);
            for (String f : this.fields) {
                if (this.useRR) {
                    this.projectedFields.put(((Field)Field.getFieldsWithName((boolean)false, (String)f).get(0)).getID(), f);
                    continue;
                }
                String projField = this.findPresentable(f);
                this.projectedFields.put(f, projField);
            }
        } else {
            Vector projections = node.getProjectIndexes();
            for (ModifierSet projection : projections) {
                String fieldLabel = null;
                fieldLabel = this.useRR ? QueryHelper.GetFieldNameById((String)projection.getBase()) : projection.getBase();
                String projField = this.findPresentable(fieldLabel);
                if (projField == null) {
                    logger.warn("Projection: " + projection.getBase() + " is not part of the presentable fields");
                    continue;
                }
                this.projectedFields.put(projection.getBase(), projField);
            }
        }
        logger.info("******************************************");
        logger.info("projectedFields : " + this.projectedFields);
        logger.info("******************************************");
        this.queryContainer.setProjectedFields(this.projectedFields);
        return this.processNode(node.subtree, nodeAnnotation.left);
    }

    private String processNode(GCQLAndNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        return this.processNode(node.left, nodeAnnotation.left) + " " + this.processNode(node.right, nodeAnnotation.right);
    }

    private String processNode(GCQLOrNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        return this.processNode(node.left, nodeAnnotation.left) + " " + this.processNode(node.right, nodeAnnotation.right);
    }

    private String processNode(GCQLNotNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        throw new Exception("Not operator is not supported by OpenSearch gCQL");
    }

    private String processNode(GCQLProxNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        throw new Exception("Proximity operator is not supported by OpenSearch gCQL");
    }

    private String processNode(GCQLTermNode node, GCQLNodeAnnotation nodeAnnotation) throws Exception {
        boolean found = false;
        String index = null;
        String fieldLabel = null;
        StringBuffer processedQuery = new StringBuffer();
        if (node.getRelation().getModifiers().size() > 0) {
            if ((((Modifier)node.getRelation().getModifiers().get(0)).getType().equals("config:numOfResults") || ((Modifier)node.getRelation().getModifiers().get(0)).getType().equals("config:sequentialResults")) && !((OpenSearchGcqlCollectionQuery)((ArrayList)((HashMap)this.queryContainer.queries.get(this.collection)).get("*")).get(0)).hasParameter(((Modifier)node.getRelation().getModifiers().get(0)).getType())) {
                ((OpenSearchGcqlCollectionQuery)((ArrayList)((HashMap)this.queryContainer.queries.get(this.collection)).get("*")).get(0)).addParameter(((Modifier)node.getRelation().getModifiers().get(0)).getType(), ((Modifier)node.getRelation().getModifiers().get(0)).getValue());
            }
            processedQuery.append(((Modifier)node.getRelation().getModifiers().get(0)).getType() + "=\"" + ((Modifier)node.getRelation().getModifiers().get(0)).getValue() + "\" ");
        }
        if (node.getIndex().equals("gDocCollectionID") || node.getIndex().equals("gDocCollectionLang")) {
            return processedQuery.toString();
        }
        fieldLabel = this.useRR ? QueryHelper.GetFieldNameById((String)node.getIndex()) : node.getIndex();
        for (String field : this.searchableFields) {
            if (fieldLabel == null || !fieldLabel.equalsIgnoreCase(field)) continue;
            index = field;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Field: " + node.getIndex() + ", is not part of the searchable fields");
        }
        String openSearchParameter = null;
        found = false;
        boolean foundParameter = false;
        openSearchParameter = (String)this.searchableExpressions.get(node.getIndex());
        if (openSearchParameter == null) {
            if (this.useRR) {
                Set ss = Field.getById((boolean)true, (String)node.getIndex()).getSearchables();
                Iterator iterator = ss.iterator();
                while (iterator.hasNext()) {
                    Searchable s = (Searchable)iterator.next();
                    if (!s.getCollection().equals(this.collection) || !s.getLocator().equals(this.dataSourceLocator)) continue;
                    openSearchParameter = s.getExpression();
                    foundParameter = true;
                    break;
                }
                if (!foundParameter) {
                    throw new Exception("Could not find OpenSearch parameter in a Searchable expression");
                }
            } else if (node.getIndex().equals("allIndexes")) {
                openSearchParameter = "http%3A%2F%2Fa9.com%2F-%2Fspec%2Fopensearch%2F1.1%2F:searchTerms";
            } else if (node.getIndex().equals("startPage")) {
                openSearchParameter = "http%3A%2F%2Fa9.com%2F-%2Fspec%2Fopensearch%2F1.1%2F:startPage";
            }
            this.searchableExpressions.put(node.getIndex(), openSearchParameter);
        }
        for (OpenSearchConstants.SupportedRelations relation : OpenSearchConstants.SupportedRelations.values()) {
            switch (1.$SwitchMap$org$gcube$opensearch$opensearchlibrary$OpenSearchConstants$SupportedRelations[relation.ordinal()]) {
                case 1: {
                    boolean foundField = false;
                    for (String field : this.searchableFields) {
                        if (!field.equals(fieldLabel)) continue;
                        foundField = true;
                        break;
                    }
                    if (foundField) break;
                    throw new Exception("Could not find field " + fieldLabel + " among searchable fields");
                }
            }
            if (!node.getRelation().getBase().equalsIgnoreCase(relation.toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Relation: " + node.getRelation().getBase() + " is not suppprted");
        }
        String processedTerm = OpenSearchGcqlProcessor.removeQuotes((String)node.getTerm());
        ((OpenSearchGcqlCollectionQuery)((ArrayList)((HashMap)this.queryContainer.queries.get(this.collection)).get("*")).get(0)).addParameter(openSearchParameter, processedTerm);
        processedQuery.append(openSearchParameter + "=\"" + processedTerm + "\"");
        logger.trace("Term Node result: " + processedQuery.toString());
        return processedQuery.toString();
    }

    static Set<Searchable> getSearchablesByName(String fieldName) throws ResourceRegistryException {
        List fields = Field.getAll((boolean)true);
        for (Field field : fields) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field.getSearchables();
        }
        return Collections.emptySet();
    }
}

