/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryClassNamePair;
import org.globus.wsrf.jndi.Initializable;

public class OpenSearchDataSourceConfig
implements Initializable {
    static GCUBELog logger = new GCUBELog(OpenSearchDataSourceConfig.class);
    private Boolean clearCacheOnStartup;
    private Long cacheRefreshIntervalMillis;
    private String openSearchLibraryFactories;
    private Map<String, FactoryClassNamePair> factories = new HashMap<String, FactoryClassNamePair>();

    public Boolean getClearCacheOnStartup() {
        return this.clearCacheOnStartup;
    }

    public Long getCacheRefreshIntervalMillis() {
        return this.cacheRefreshIntervalMillis;
    }

    public Map<String, FactoryClassNamePair> getFactories() {
        return this.factories;
    }

    public String getOpenSearchLibraryFactories() {
        return this.openSearchLibraryFactories;
    }

    public void setClearCacheOnStartup(Boolean clearCacheOnStartup) {
        this.clearCacheOnStartup = clearCacheOnStartup;
    }

    public void setCacheRefreshIntervalMillis(Long cacheRefreshIntervalMillis) {
        this.cacheRefreshIntervalMillis = cacheRefreshIntervalMillis;
    }

    public void setOpenSearchLibraryFactories(String openSearchLibraryFactories) {
        this.openSearchLibraryFactories = openSearchLibraryFactories;
    }

    public void initialize() throws Exception {
        Pattern factoriesPattern = Pattern.compile("\\[[^=]*=\\([^,]*,[^\\)]*\\)\\]");
        Matcher factoriesMatcher = factoriesPattern.matcher(this.openSearchLibraryFactories);
        while (factoriesMatcher.find()) {
            String factoryEntry = factoriesMatcher.group().trim();
            String[] keyValue = (factoryEntry = factoryEntry.substring(1).substring(0, factoryEntry.length() - 2)).split("=");
            if (keyValue.length != 2) {
                System.out.println("Failed to parse factory entry: " + factoryEntry + ". Ignoring entry");
                continue;
            }
            try {
                this.factories.put(keyValue[0].trim(), new FactoryClassNamePair(keyValue[1]));
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to parse factory pair: " + keyValue[1] + ". Ignoring entry"));
            }
        }
        logger.debug((Object)("Initialized OpenSearchDataSource Config:\n   clearCacheOnStartup: " + this.clearCacheOnStartup + "\n   cacheRefreshIntervalMillis: " + this.cacheRefreshIntervalMillis + "\n   factories: " + this.factories));
    }
}

