/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource;

import java.net.InetAddress;
import java.net.URI;
import java.rmi.RemoteException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResource;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResourceHome;
import org.gcube.opensearch.opensearchdatasource.StatefulContext;
import org.gcube.opensearch.opensearchdatasource.stubs.AddProvidersParams;
import org.gcube.opensearch.opensearchdatasource.stubs.AddProvidersResponse;
import org.gcube.opensearch.opensearchdatasource.stubs.Provider;
import org.gcube.opensearch.opensearchdatasource.stubs.RefreshCache;
import org.gcube.opensearch.opensearchdatasource.stubs.RefreshCacheResponse;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;

public class OpenSearchDataSource {
    public String[] supportedRelations;
    String hostName = "";
    static GCUBELog logger = new GCUBELog(OpenSearchDataSource.class);

    public OpenSearchDataSource() throws RemoteException {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot set hostname");
            logger.error((Object)e.toString());
            throw new RemoteException("Exception when getting hostname", e);
        }
        logger.debug((Object)"OpenSearchDataSource constructed");
    }

    public String query(String cqlQuery) throws RemoteException {
        OpenSearchDataSourceResource opensearchResource = this.getResource();
        logger.info((Object)(opensearchResource.getAdaptorID() + " received query: " + cqlQuery));
        URI loc = opensearchResource.query(cqlQuery);
        return loc.toString();
    }

    public RefreshCacheResponse refreshCache(RefreshCache req) throws RemoteException {
        OpenSearchDataSourceResourceHome wsHome = (OpenSearchDataSourceResourceHome)StatefulContext.getPortTypeContext().getWSHome();
        wsHome.refreshCache();
        return new RefreshCacheResponse();
    }

    public AddProvidersResponse addProviders(AddProvidersParams req) throws RemoteException {
        OpenSearchDataSourceResource opensearchResource = this.getResource();
        String[] fields = req.getFields().getArray() != null ? req.getFields().getArray() : new String[]{};
        int providerCount = req.getProviders().length;
        String[] collectionIDs = new String[providerCount];
        String[] openSearchResourceIDs = new String[providerCount];
        String[][] fixedParameters = new String[providerCount][];
        Provider[] providers = req.getProviders();
        for (int i = 0; i < providerCount; ++i) {
            collectionIDs[i] = providers[i].getCollectionID();
            openSearchResourceIDs[i] = providers[i].getOpenSearchResourceID();
            fixedParameters[i] = providers[i].getFixedParameters().getArray() != null ? providers[i].getFixedParameters().getArray() : new String[]{};
        }
        try {
            opensearchResource.addProviders(fields, collectionIDs, openSearchResourceIDs, fixedParameters);
        }
        catch (Exception e) {
            throw new RemoteException("Error while adding provider", e);
        }
        opensearchResource.store();
        return new AddProvidersResponse();
    }

    private OpenSearchDataSourceResource getResource() throws RemoteException {
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get the OpenSearchDataSource resource");
            throw new RemoteException("Unable to access resource.", e);
        }
        OpenSearchDataSourceResource openSearchResource = (OpenSearchDataSourceResource)resource;
        return openSearchResource;
    }

    public static void ready() {
    }

    public static enum SupportedRelations {
        eq{

            public String toString() {
                return "=";
            }
        }
        ,
        exact{

            public String toString() {
                return "==";
            }
        }
        ,
        any,
        all;

    }
}

