package org.gcube.messaging.monitoring.probes.ghn;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.Test.TestType;
import org.gcube.messaging.common.messages.*;
import org.gcube.messaging.common.producer.*;


/**
 * Abstract GHNProbe
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public abstract class GHNProbe extends GCUBETestProbe{
	

	protected int number= 0;	
	
	protected String ghnName;
	
	boolean exception = false;
	
	public GHNProbe(){
		ghnName = GHNContext.getContext().getHostnameAndPort();
		
	}

	/**
	 * Send a Test using the JMS Client
	 */
	public  void sendMessageWithTest(Test test){
		test.setPriority(Test.Priority.LOW);
		for (GCUBEScope scope : GCUBELocalProducer.getMonitoredScope()){
			GHNMessage<Test> message = new GHNMessage<Test>(ghnName,scope);
			message.setTest(test);
			message.setTimeNow();
			this.sendMessage(message);
		}
	}
	
	/**
	 * Send Message using the JMS Client
	 */
	public  void sendMessage(GCUBEMessage message){
		ActiveMQClient.getSingleton().sendMessage(message,TestType.TEST.name());
	}

}
