package org.gcube.messaging.monitoring.probes.ghn;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.contexts.ghn.Events.GHNLifeTimeEvent;
import org.gcube.common.core.contexts.ghn.Events.GHNTopic;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBENotificationProbe;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBEResource.ResourceConsumer;
import org.gcube.common.core.resources.GCUBEResource.ResourceTopic;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.messaging.common.messages.*;
import org.gcube.messaging.common.messages.Test;
import org.gcube.messaging.common.messages.Test.TestType;
import org.gcube.messaging.common.producer.*;

/**
 * Implementation of a GHNNotifictionProbe that subscribe for GHN events and dispatch messages to the Broker 
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class GHNNotificationProbe extends GCUBENotificationProbe{

	String ghnName;	 
	
	public GHNNotificationProbe(){
		ghnName = GHNContext.getContext().getHostnameAndPort();
	}

	/**
	 * Extends a Resource Consumer with  the information about the GHN
	 * 
	 * @author Andrea Manzi(CERN)
	 *
	 */
	private class GHNResourceConsumer extends ResourceConsumer{
		
		String ghnName ;
		
		GHNResourceConsumer(String ghnName){
			this.ghnName = ghnName;
		
		}
		/**
		 * {@inheritDoc}
		 */
		protected void onAddScope(GCUBEResource.AddScopeEvent event) {
			for (GCUBEScope scope :event.getPayload())
			{	
				try {
					GCUBELocalProducer.addScope(scope);
				} catch (BrokerNotConfiguredInScopeException e) {
					logger.error("Broker not configured for scope "+scope.toString(),e);
				} catch (GCUBEScopeNotSupportedException e) {
					logger.error("GCUBEScope not supported",e);
				} catch (Exception e) {
					logger.error("Exception adding scope",e);
				}
				logger.debug("Added Scope " +scope.toString() +" to GHN");	
				Test test = new Test();
				test.setDescription("Added Scope "+scope.toString()+" to GHN");
				test.setType(Test.TestType.NOTIFICATION);
				test.setTestResult(scope.toString());
				//check if the scope belong to GHN startScopes
				if (GCUBELocalProducer.checkStartScope(scope))
					test.setPriority(Test.Priority.LOW);
				else test.setPriority(Test.Priority.HIGH);
				GHNNotificationProbe.sendGHNTest(test);
				
			}
				
		}
		/**
		 * {@inheritDoc}
		 */
			protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
				for (GCUBEScope o :event.getPayload())
				{	
					logger.debug("Removed Scope "+o.toString() +" from GHN");	
					Test test = new Test();
					test.setDescription("Removed Scope "+o.toString()+" from GHN");
					test.setType(Test.TestType.NOTIFICATION);
					test.setTestResult(o.toString());
					test.setPriority(Test.Priority.HIGH);
					GHNNotificationProbe.sendGHNTest(test);
					//send message to currrent scope too
					GHNNotificationProbe.sendGHNTest(test,(GCUBEScope)o);
					GCUBELocalProducer.removeScope(o);
					
				}	
			}
			
			
	}
	/*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.utils.handlers.GCUBEHandler#run()
	 */
	@Override
	public void run() throws Exception {
		
		GHNConsumer ghnManager = new GHNConsumer() {
			
			/** {@inheritDoc} */
			protected void onGHNShutdown(GHNLifeTimeEvent event) {
				
				logger.debug("GHN shutdown event received");		
				Test test = new Test();
	        	test.setDescription("GHN shutdown event received");
	        	test.setType(Test.TestType.NOTIFICATION);
	        	test.setPriority(Test.Priority.HIGH);
	        	GHNNotificationProbe.sendGHNTest(test);
	        	GHNContext.getContext().unsubscribeGHNEvents(this, GHNTopic.READY,GHNTopic.SHUTDOWN);
			}
			/**
			 * {@inheritDoc} */
			 
			protected void onGHNReady(GHNLifeTimeEvent event) {
				logger.debug("GHN Ready event received");				
				Test test = new Test();
	        	test.setDescription("GHN Ready event received");
	        	test.setType(Test.TestType.NOTIFICATION);
	        	test.setPriority(Test.Priority.HIGH);
	        	GHNNotificationProbe.sendGHNTest(test);
	        
			}
			
		};

		try {
			GHNContext.getContext().subscribeGHNEvents(ghnManager, GHNTopic.READY,GHNTopic.SHUTDOWN);
			GHNContext.getContext().getGHN().subscribeResourceEvents(new GHNResourceConsumer(GHNContext.getContext().getHostnameAndPort()),ResourceTopic.ADDSCOPE,ResourceTopic.REMOVESCOPE);
			
		}	catch (Exception e)
		{
			GCUBELocalProducer.logger.error("Error subscribing to Local events",e);
		}
		

	}
	
	public  void sendMessage(GCUBEMessage message){
		ActiveMQClient.getSingleton().sendMessage(message,TestType.NOTIFICATION.name());
	}
	
	public static void sendGHNTest(Test test){
		new GHNNotificationProbe().sendMessageWithTest(test);
	}
	
	public static void sendGHNTest(Test test,GCUBEScope scope){
		new GHNNotificationProbe().sendMessageWithTest(test,scope);
	}
	
	public static GHNMessage createGHNMessage(GCUBEScope scope){
		return new GHNMessage(GHNContext.getContext().getHostnameAndPort(),scope);
	
	}

	/**
	 * Send a Test using the JMS Client
	 */
	public  void sendMessageWithTest(Test test){
		for (GCUBEScope scope : GCUBELocalProducer.getMonitoredScope()){
			GHNMessage<Test> message = new GHNMessage<Test>(ghnName,scope);
			message.setTest(test);
			message.setTimeNow();
			this.sendMessage(message);
		}
	}
	/**
	 * Send a Test using the JMS Client
	 */
	public  void sendMessageWithTest(Test test,GCUBEScope scope){
			GHNMessage<Test> message = new GHNMessage<Test>(ghnName,scope);
			message.setTest(test);
			message.setTimeNow();
			this.sendMessage(message);
		}
	
}
