package org.gcube.messaging.monitoring.probes.ghn;

import java.util.Map;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.messaging.common.messages.Test;


/**
 * Check Virtual Memory on GHN
 * 
 * @author Andrea Manzi (CERN)
 *
 */
public class GHNMemoryProbe extends GHNProbe{

	/**
	 * Default Constructor
	 */
	public GHNMemoryProbe(){}	/*
	 * /(non-Javadoc)
	 * @see org.gcube.common.core.utils.handlers.GCUBEHandler#run()
	 */
	@Override
	public void run() throws Exception {
		Test test = new Test();
		try {
			Map<String,Long> mem = GHNContext.getContext().getMemoryUsage();
			test.setDescription("Check Virtual Memory Available");
			test.setType(Test.TestType.MEMORY_AVAILABLE);
			test.setTestNumber(Integer.valueOf(number++));
			test.setTestResult(new Long( mem.get("VirtualAvailable"))*1048576);
			sendMessageWithTest(test);
		}catch (Exception e){
			logger.error("Error getting Memory Available",e);
		} 
	}

}

