/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.db;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;
import org.gcube.messaging.common.consumer.ServiceContext;

public class PoolManager {
    private GenericObjectPool internalDBconnectionPool;
    private ConnectionFactory internalDBconnectionFactory;
    private PoolableConnectionFactory internalDBpoolableConnectionFactory;
    private PoolingDriver internalDBdriver;
    private String validationQUERY = "Select 1";
    private String internalDBconnectionString = null;
    private String dbName;

    public PoolManager(String dbName) {
        this.dbName = dbName;
        try {
            this.internalDBconnectionString = ServiceContext.getContext().getDbhost() + ":" + ServiceContext.getContext().getDbport() + "/" + dbName;
            Class.forName("com.mysql.jdbc.Driver");
            this.internalDBconnectionString = "jdbc:mysql://" + this.internalDBconnectionString;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.internalDBconnectionPool = new GenericObjectPool(null);
        this.internalDBconnectionPool.setMaxActive(ServiceContext.getContext().getMaxDBConnections().intValue());
        this.internalDBconnectionPool.setTestOnBorrow(true);
        this.internalDBconnectionPool.setWhenExhaustedAction((byte)1);
        this.internalDBconnectionFactory = new DriverManagerConnectionFactory(this.internalDBconnectionString, ServiceContext.getContext().getDbuser(), ServiceContext.getContext().getDbpass());
        this.internalDBpoolableConnectionFactory = new PoolableConnectionFactory(this.internalDBconnectionFactory, (ObjectPool)this.internalDBconnectionPool, (KeyedObjectPoolFactory)new StackKeyedObjectPoolFactory(), this.validationQUERY, false, true);
        this.internalDBdriver = new PoolingDriver();
        this.internalDBdriver.registerPool(dbName, (ObjectPool)this.internalDBconnectionPool);
    }

    public Connection getInternalDBConnection() throws Exception {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.dbName);
    }

    public String getInternalConnectionString() {
        return this.internalDBconnectionString;
    }
}

