/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.liferay;

import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.rpc.ServiceException;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.vomanagement.usermanagement.ws.GetGroupId;
import org.gcube.vomanagement.usermanagement.ws.GetGroupIdResponse;
import org.gcube.vomanagement.usermanagement.ws.LiferaySOAPGroupManagerPortType;
import org.gcube.vomanagement.usermanagement.ws.LiferaySOAPRoleManagerPortType;
import org.gcube.vomanagement.usermanagement.ws.LiferaySOAPUserManagerPortType;
import org.gcube.vomanagement.usermanagement.ws.ListRolesByUser;
import org.gcube.vomanagement.usermanagement.ws.ListRolesByUserResponse;
import org.gcube.vomanagement.usermanagement.ws.ListUsersByGroup;
import org.gcube.vomanagement.usermanagement.ws.ListUsersByGroupResponse;
import org.gcube.vomanagement.usermanagement.ws.RoleModel;
import org.gcube.vomanagement.usermanagement.ws.UserModel;
import org.gcube.vomanagement.usermanagement.ws.UserModelCustomAttrsMapEntry;
import org.gcube.vomanagement.usermanagement.ws.service.LiferaySOAPGroupManagerServiceAddressingLocator;
import org.gcube.vomanagement.usermanagement.ws.service.LiferaySOAPRoleManagerServiceAddressingLocator;
import org.gcube.vomanagement.usermanagement.ws.service.LiferaySOAPUserManagerServiceAddressingLocator;

public class LiferayClient {
    static String serviceUserManagerName = "LiferaySOAPUserManager";
    static String serviceGropuManagerName = "LiferaySOAPGroupManager";
    static String serviceRoleName = "LiferaySOAPRoleManager";
    public static String basePortalURL = (String)ServiceContext.getContext().getProperty("portalBaseURL", new boolean[]{true});
    public static String siteManagerRoleName = (String)ServiceContext.getContext().getProperty("siteManagerRoleName", new boolean[]{true});
    public static String infraManagerRoleName = (String)ServiceContext.getContext().getProperty("infraManagerRoleName", new boolean[]{true});
    public static String receiveNotificationCustomAttributeName = (String)ServiceContext.getContext().getProperty("receiveNotificationCustomAttributeName", new boolean[]{true});
    public static String receiveSummaryCustomAttributeName = (String)ServiceContext.getContext().getProperty("receiveSummaryCustomAttributeName", new boolean[]{true});
    public static String siteNameCustomAttributeName = (String)ServiceContext.getContext().getProperty("siteNameCustomAttributeName", new boolean[]{true});
    public static String siteDomainsCustomAttributeName = (String)ServiceContext.getContext().getProperty("siteDomainsCustomAttributeName", new boolean[]{true});

    public UserModel[] getUsersPerGroup(String groupID) throws ServiceException, Exception {
        LiferaySOAPUserManagerPortType ptUser = new LiferaySOAPUserManagerServiceAddressingLocator().getLiferaySOAPUserManagerPortTypePort(this._getURL(serviceUserManagerName));
        ListUsersByGroup req = new ListUsersByGroup();
        req.setArg0(groupID);
        ListUsersByGroupResponse response_users = ptUser.listUsersByGroup(req);
        UserModel[] users = response_users.get_return();
        return users;
    }

    public RoleModel[] getUserRoles(String userID) throws ServiceException, Exception {
        LiferaySOAPRoleManagerPortType roleManagerStub = new LiferaySOAPRoleManagerServiceAddressingLocator().getLiferaySOAPRoleManagerPortTypePort(this._getURL(serviceRoleName));
        ListRolesByUser roleData = new ListRolesByUser();
        roleData.setArg0(userID);
        ListRolesByUserResponse listRolesResponse = roleManagerStub.listRolesByUser(roleData);
        return listRolesResponse.get_return();
    }

    public ArrayList<UserModel> getUsersWithRole(String rolemame) throws ServiceException, Exception {
        LiferaySOAPGroupManagerPortType groupPortType = new LiferaySOAPGroupManagerServiceAddressingLocator().getLiferaySOAPGroupManagerPortTypePort(this._getURL(serviceGropuManagerName));
        GetGroupId groupIDRequest = new GetGroupId();
        String infrastructureGroup = GHNContext.getContext().getStartScopes()[0].getInfrastructure().getName();
        groupIDRequest.setArg0(infrastructureGroup);
        GetGroupIdResponse response = groupPortType.getGroupId(groupIDRequest);
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserModel user : this.getUsersPerGroup(response.get_return())) {
            RoleModel[] roles;
            for (RoleModel role : roles = this.getUserRoles(user.getUserId())) {
                if (role == null || role.getRoleName() == null || role.getRoleName().compareTo(rolemame) != 0) continue;
                users.add(user);
            }
        }
        return users;
    }

    public static void main(String[] args) {
        UserModelCustomAttrsMapEntry entry;
        int i;
        LiferayClient client = new LiferayClient();
        try {
            for (UserModel user : client.getUsersWithRole(infraManagerRoleName)) {
                System.out.println(user.getScreenName());
                System.out.println(user.getEmail());
                for (i = 0; i < user.getCustomAttrsMap().getEntry().length; ++i) {
                    entry = user.getCustomAttrsMap().getEntry(i);
                    System.out.println(entry.getKey());
                    System.out.println(entry.getValue());
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (UserModel user : client.getUsersWithRole(siteManagerRoleName)) {
                System.out.println(user.getScreenName());
                System.out.println(user.getEmail());
                for (i = 0; i < user.getCustomAttrsMap().getEntry().length; ++i) {
                    entry = user.getCustomAttrsMap().getEntry(i);
                    System.out.println(entry.getKey());
                    System.out.println(entry.getValue());
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL _getURL(String serviceName) throws Exception {
        return new URL(basePortalURL + File.separator + "usermanagement-ws" + File.separator + serviceName);
    }
}

