/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.ghn;

import java.text.SimpleDateFormat;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.Constants;
import org.gcube.messaging.common.consumer.MessageChecker;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.ghn.GHNNotification;
import org.gcube.messaging.common.messages.GHNMessage;
import org.gcube.messaging.common.messages.Test;

public class GHNMessageChecker
extends MessageChecker<GHNMessage<?>> {
    static Long diskQuotaThreshold = null;
    static Long virtualMemoryThreshold = null;
    static Double cpuLoadThreshold = null;
    public static GCUBELog logger = new GCUBELog(GHNMessageChecker.class);
    static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public GHNMessageChecker(GCUBEScope scope) {
        super(scope);
        diskQuotaThreshold = ServiceContext.getContext().getMailClient().getScopeMap().get(scope.toString()).getDiskQuotaThreshold();
        if (diskQuotaThreshold == null) {
            try {
                diskQuotaThreshold = (Long)ServiceContext.getContext().getProperty("diskQuotaThreshold", new boolean[]{true});
                logger.debug((Object)("Configure DiskQuota filter with threshold: " + diskQuotaThreshold));
            }
            catch (RuntimeException e) {
                logger.debug((Object)"Unable to configure DiskQuota filter");
            }
        } else {
            logger.debug((Object)("DiskQuota filter retrieved from IS: " + diskQuotaThreshold));
        }
        virtualMemoryThreshold = ServiceContext.getContext().getMailClient().getScopeMap().get(scope.toString()).getVirtualMemoryThreshold();
        if (virtualMemoryThreshold == null) {
            try {
                virtualMemoryThreshold = (Long)ServiceContext.getContext().getProperty("virtualMemoryThreshold", new boolean[]{true});
                logger.debug((Object)("Configure VirtualMemory filter with threshold: " + virtualMemoryThreshold));
            }
            catch (RuntimeException e) {
                logger.debug((Object)"Unable to configure VirtualMemory filter");
            }
        } else {
            logger.debug((Object)("VirtualMemory filter retrieved from IS: " + virtualMemoryThreshold));
        }
        cpuLoadThreshold = ServiceContext.getContext().getMailClient().getScopeMap().get(scope.toString()).getCpuLoadThreshold();
        if (cpuLoadThreshold == null) {
            try {
                cpuLoadThreshold = (Double)ServiceContext.getContext().getProperty("cpuLoadThreshold", new boolean[]{true});
                logger.debug((Object)("Configure CPU Load filter with threshold: " + cpuLoadThreshold));
            }
            catch (RuntimeException e) {
                logger.debug((Object)"Unable to configure CPULoad filter");
            }
        } else {
            logger.debug((Object)("CPU Load filter  retrieved from IS: " + cpuLoadThreshold));
        }
    }

    @Override
    public void check(GHNMessage<?> message) throws Exception {
        if (!message.getTopic().contains("GHN")) {
            return;
        }
        GHNNotification not = new GHNNotification();
        boolean notify = false;
        boolean quota_disk_not_assessable = false;
        switch (message.getTest().getType()) {
            case DISK_QUOTA: {
                if (diskQuotaThreshold != null && (Long)message.getTest().getTestResult() == 0L) {
                    not.setMessage(ServiceContext.getContext().getMailTemplateParser().getTemplateMap().get("DISK_QUOTA_NOT_ASSESSABLE"));
                    quota_disk_not_assessable = true;
                    notify = true;
                    break;
                }
                if (diskQuotaThreshold == null || ((Long)message.getTest().getTestResult()).compareTo(diskQuotaThreshold) >= 0) break;
                not.setMessage(ServiceContext.getContext().getMailTemplateParser().getTemplateMap().get(message.getTest().getType().name()).replace(Constants.MailTemplateToken.SPACE.toString(), message.getTest().getTestResult().toString()));
                notify = true;
                break;
            }
            case CPU_LOAD: {
                if (cpuLoadThreshold == null || ((Double)message.getTest().getTestResult()).compareTo(cpuLoadThreshold) <= 0) break;
                Double cpuLoad = (Double)message.getTest().getTestResult();
                Long overload = new Double(cpuLoad * 100.0).longValue() - 100L;
                not.setMessage(ServiceContext.getContext().getMailTemplateParser().getTemplateMap().get(message.getTest().getType().name()).replace(Constants.MailTemplateToken.OVERLOAD.toString(), overload.toString()));
                notify = true;
                break;
            }
            case MEMORY_AVAILABLE: {
                if (virtualMemoryThreshold == null || ((Long)message.getTest().getTestResult()).compareTo(virtualMemoryThreshold) >= 0) break;
                not.setMessage(ServiceContext.getContext().getMailTemplateParser().getTemplateMap().get(message.getTest().getType().name()).replace(Constants.MailTemplateToken.SPACE.toString(), message.getTest().getTestResult().toString()));
                notify = true;
                break;
            }
            case NOTIFICATION: {
                if (message.getTest().getPriority().compareTo((Enum)Test.Priority.HIGH) != 0) break;
                not.setMessage(ServiceContext.getContext().getMailTemplateParser().getTemplateMap().get(message.getTest().getType().name()).replace(Constants.MailTemplateToken.INFO.toString(), message.getTest().getDescription()));
                notify = true;
                break;
            }
        }
        if (notify) {
            not.setSourceGHN(message.getSourceGHN());
            not.setScope(GCUBEScope.getScope((String)message.getScope()));
            if (quota_disk_not_assessable) {
                not.setType("DISK_QUOTA_NOT_ASSESSABLE");
            } else {
                not.setType(message.getTest().getType().toString());
            }
            not.setTime(message.getTime());
            ServiceContext.getContext().getNotifier().enqueue(not);
            ServiceContext.getContext().getMonitoringManager().insertNotification(not);
        }
        ServiceContext.getContext().getMonitoringManager().InsertGHNMessage(message);
    }
}

