/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.db;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.UUID;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.db.DBManager;
import org.gcube.messaging.common.consumer.db.PoolManager;
import org.gcube.messaging.common.messages.MessageField;
import org.gcube.messaging.common.messages.SystemAccountingMessage;
import org.gcube.messaging.common.messages.util.SQLType;

public class AccountingSystemDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(AccountingSystemDBManager.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AccountingSystemDBManager() {
        this.dbFileBaseFolder = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + File.separator + "AccountingSystemDB";
        this.dbName = "system_accounting";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "AccountingSystemDBBackup");
        this.queriesFile = new File(GHNContext.getContext().getLocation() + File.separator + (String)ServiceContext.getContext().getProperty("configDir", new boolean[0]) + File.separator + (String)ServiceContext.getContext().getProperty("AccountingSystemDBFile", new boolean[]{true}));
        this.connection = null;
        if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
            Thread t = new Thread(this);
            t.start();
        }
        this.poolManager = new PoolManager(this.dbName);
    }

    @Override
    protected void connectToMySql() throws Exception {
        this.connection = this.poolManager.getInternalDBConnection();
        this.connection.setAutoCommit(true);
    }

    @Override
    public void open() throws ClassNotFoundException, SQLException, Exception {
        if (this.connection == null) {
            if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
                this.connectToEmbeddedDB();
            } else {
                this.connectToMySql();
            }
        }
        String testQuery = "SELECT LIMIT 1 1 * FROM ACCOUNTINGSYTEMTYPE";
        DBManager.BaseConsumer baseConsumer = new DBManager.BaseConsumer(){

            @Override
            public void consume(ResultSet resultset) throws Exception {
            }
        };
        try {
            this.queryAndConsume(testQuery, baseConsumer);
        }
        catch (Exception e) {
            this.createDB();
        }
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }

    private boolean isTableOnDB(String tableName) {
        String TABLE_NAME = "TABLE_NAME";
        String[] TABLE_TYPES = new String[]{"TABLE"};
        try {
            DatabaseMetaData dbmd = this.connection.getMetaData();
            ResultSet tables = dbmd.getTables(null, null, null, TABLE_TYPES);
            while (tables.next()) {
                if (tables.getString(TABLE_NAME).compareTo(tableName) != 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"Error getting database Information", (Throwable)e);
        }
        return false;
    }

    private String checkType(SQLType type) {
        if (type.getName().compareTo("VARCHAR") == 0) {
            return "VARCHAR(256)";
        }
        return type.getName();
    }

    public synchronized void storeSystemAccoutingInfo(SystemAccountingMessage message) {
        String type = message.getMessageType();
        if (!this.isTableOnDB(type)) {
            try {
                this.logger.debug((Object)("CREATING the following table: " + type + " INTO DB"));
                String create = "CREATE TABLE " + type + " (" + "id VARCHAR(64) NOT NULL," + "scope VARCHAR(128) NOT NULL," + "serviceClass VARCHAR(64)," + "serviceName VARCHAR(128)," + "sourceGHN VARCHAR(128) NOT NULL," + "datetime DATETIME  NOT NULL,";
                for (String key : message.getFieldMap().keySet()) {
                    create = create + key + " " + this.checkType(((MessageField)message.getFieldMap().get(key)).getSqlType()) + ",";
                }
                create = create.substring(0, create.length() - 1);
                create = create + ");";
                this.logger.debug((Object)("Expression: " + create));
                this.update(create);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error Creating table into DB", (Throwable)e);
            }
        }
        this.logger.debug((Object)("INSERT the following msg: " + message.toString() + " INTO DB"));
        String id = UUID.randomUUID().toString();
        try {
            String expression = "INSERT INTO " + type + " VALUES ('" + id + "','" + message.getScope() + "','" + message.getServiceClass() + "','" + message.getServiceName() + "','" + message.getSourceGHN() + "','" + message.getTime() + "','";
            for (String key : message.getFieldMap().keySet()) {
                expression = expression + ((MessageField)message.getFieldMap().get(key)).getValue() + "','";
            }
            expression = expression.substring(0, expression.length() - 2);
            expression = expression + ");";
            this.logger.debug((Object)("Expression: " + expression));
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }
}

