/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.json.JSONObject;
import org.gcube.messaging.common.consumerlibrary.query.AccountingQuery;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.messages.records.AISRecord;
import org.gcube.messaging.common.messages.records.AdvancedSearchRecord;
import org.gcube.messaging.common.messages.records.AnnotationRecord;
import org.gcube.messaging.common.messages.records.AquamapsRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.BrowseRecord;
import org.gcube.messaging.common.messages.records.ContentRecord;
import org.gcube.messaging.common.messages.records.DocumentWorkflowRecord;
import org.gcube.messaging.common.messages.records.GenericRecord;
import org.gcube.messaging.common.messages.records.GoogleSearchRecord;
import org.gcube.messaging.common.messages.records.HLRecord;
import org.gcube.messaging.common.messages.records.LoginRecord;
import org.gcube.messaging.common.messages.records.QuickSearchRecord;
import org.gcube.messaging.common.messages.records.ReportRecord;
import org.gcube.messaging.common.messages.records.SimpleSearchRecord;
import org.gcube.messaging.common.messages.records.TSRecord;
import org.gcube.messaging.common.messages.records.WarRecord;
import org.gcube.messaging.common.messages.records.WebAppRecord;

public class PortalAccountingQuery
extends AccountingQuery {
    private static final long serialVersionUID = 1L;

    public <TYPE extends BaseRecord> String queryByType(Class<TYPE> clazz) throws Exception {
        this.setQuery(this.selectQuery(clazz));
        this.query();
        return this.getResults();
    }

    public String queryByType(String string, String[] stringArray) throws Exception {
        this.setQuery(this.selectQuery(string) + this.selectDateFiler(stringArray, " AND"));
        this.query();
        return this.getResults();
    }

    private String selectDateFiler(String[] stringArray, String string) {
        String string2 = "";
        switch (stringArray.length) {
            case 0: {
                break;
            }
            case 1: {
                string2 = string + " date='" + stringArray[0] + "'";
                break;
            }
            case 2: {
                string2 = string + " date BETWEEN '" + stringArray[0] + "' AND '" + stringArray[1] + "'";
            }
        }
        return string2;
    }

    public <TYPE extends BaseRecord> String queryByUser(Class<TYPE> clazz, String string, GCUBEScope ... gCUBEScopeArray) throws Exception {
        this.setQuery(this.selectQuery(clazz) + " AND user='" + string + "'" + (gCUBEScopeArray.length > 0 ? " AND vre='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        return this.getResults();
    }

    public String queryByUser(String string, String string2, String[] stringArray, GCUBEScope ... gCUBEScopeArray) throws Exception {
        this.setQuery(this.selectQuery(string) + " AND user='" + string2 + "'" + this.selectDateFiler(stringArray, " AND") + (gCUBEScopeArray.length > 0 ? " AND vre='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        return this.getResults();
    }

    public <TYPE extends BaseRecord> Long countByType(Class<TYPE> clazz, GCUBEScope ... gCUBEScopeArray) throws Exception {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", clazz.getSimpleName()) + (gCUBEScopeArray.length > 0 ? " AND vre='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        Long l = null;
        l = this.toJSON().getJSONObject(0).getLong("COUNT");
        return l;
    }

    public <TYPE extends BaseRecord> Long countByUser(Class<TYPE> clazz, String string, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", clazz.getSimpleName()) + " AND user='" + string + "'" + (gCUBEScopeArray.length > 0 ? " AND vre='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        Long l = null;
        l = this.toJSON().getJSONObject(0).getLong("COUNT");
        return l;
    }

    public Long countByType(String string, GCUBEScope ... gCUBEScopeArray) throws Exception {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", string) + (gCUBEScopeArray.length > 0 ? " AND vre='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        Long l = null;
        l = this.toJSON().getJSONObject(0).getLong("COUNT");
        return l;
    }

    public Long countByUser(String string, String string2, GCUBEScope ... gCUBEScopeArray) throws Exception, EmptyResultException {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", string) + " AND user='" + string2 + "'" + (gCUBEScopeArray.length > 0 ? " AND vre='" + gCUBEScopeArray[0].toString() + "'" : ""));
        this.query();
        Long l = null;
        l = this.toJSON().getJSONObject(0).getLong("COUNT");
        return l;
    }

    public String countByTypeAndUserWithGrouping(String string, String string2, String[] stringArray, String ... stringArray2) throws Exception, EmptyResultException {
        String string3 = "";
        String string4 = "";
        if (string.compareTo("") != 0) {
            string3 = " AND ";
        }
        if (stringArray2.length > 0) {
            string4 = "AND";
        }
        this.setQuery("SELECT COUNT(Id) AS CNT, ***GROUPBY*** AS GRP FROM PORTALACCOUNTING".replace("***GROUPBY***", string2) + " WHERE " + this.selectDateFiler(stringArray, "") + string3 + (string.compareTo("") != 0 ? " type='" + string + "'" : "") + string4 + (stringArray2.length > 0 ? " user='" + stringArray2[0].toString() + "'" : ""));
        this.setGroupClause(string2);
        this.query();
        return this.getResults();
    }

    public HashMap<String, String> getCollections(String string) throws EmptyResultException, Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setQuery("SELECT * FROM COLLECTION WHERE Id='***ID***' ".replace("***ID***", string));
        this.query();
        JSONArray jSONArray = this.toJSON();
        for (int i = 0; i < jSONArray.length(); ++i) {
            hashMap.put(jSONArray.getJSONObject(i).getString("identifier"), jSONArray.getJSONObject(i).getString("name"));
        }
        return hashMap;
    }

    public HashMap<String, String> getTerms(String string) throws EmptyResultException, Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setQuery("SELECT * FROM TERM WHERE Id='***ID***'".replace("***ID***", string));
        this.query();
        JSONArray jSONArray = this.toJSON();
        for (int i = 0; i < jSONArray.length(); ++i) {
            hashMap.put(jSONArray.getJSONObject(i).getString("name"), jSONArray.getJSONObject(i).getString("value"));
        }
        return hashMap;
    }

    public HashMap<String, String> getWebAppDetails(String string) throws EmptyResultException, Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setQuery("SELECT * FROM WEBAPPDETAIL WHERE Id='***ID***' ".replace("***ID***", string));
        this.query();
        JSONArray jSONArray = this.toJSON();
        for (int i = 0; i < jSONArray.length(); ++i) {
            hashMap.put(jSONArray.getJSONObject(i).getString("WEBAPPID"), jSONArray.getJSONObject(i).getString("WEBAPPNAME"));
        }
        return hashMap;
    }

    public HashMap<String, String> getGHNDetails(String string) throws EmptyResultException, Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setQuery("SELECT * FROM GHNDETAIL WHERE Id='***ID***' ".replace("***ID***", string));
        this.query();
        JSONArray jSONArray = this.toJSON();
        for (int i = 0; i < jSONArray.length(); ++i) {
            hashMap.put(jSONArray.getJSONObject(i).getString("GHNID"), jSONArray.getJSONObject(i).getString("GHNNAME"));
        }
        return hashMap;
    }

    public HashMap<String, String> getAddresseesGCUBEUsers(String string) throws EmptyResultException, Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setQuery("SELECT * FROM GCUBEUSERSADDRESSEES WHERE Id='***ID***' ".replace("***ID***", string));
        this.query();
        JSONArray jSONArray = this.toJSON();
        for (int i = 0; i < jSONArray.length(); ++i) {
            hashMap.put(jSONArray.getJSONObject(i).getString("NAME"), jSONArray.getJSONObject(i).getString("VRE"));
        }
        return hashMap;
    }

    public String[] getContent(String string) throws EmptyResultException, Exception {
        String[] stringArray = new String[2];
        this.setQuery("SELECT * FROM CONTENT WHERE Id='***ID***'".replace("***ID***", string));
        this.query();
        JSONArray jSONArray = this.toJSON();
        stringArray[0] = jSONArray.getJSONObject(0).getString("identifier");
        stringArray[1] = jSONArray.getJSONObject(0).getString("name");
        return stringArray;
    }

    public <TYPE extends BaseRecord> ArrayList<PortalAccountingMessage<TYPE>> getResultsAsMessage(Class<TYPE> clazz) throws Exception, EmptyResultException {
        ArrayList<PortalAccountingMessage<TYPE>> arrayList = new ArrayList<PortalAccountingMessage<TYPE>>();
        JSONArray jSONArray = this.toJSON();
        for (int i = 0; i < jSONArray.length(); ++i) {
            PortalAccountingMessage portalAccountingMessage = new PortalAccountingMessage();
            portalAccountingMessage.setUser(jSONArray.getJSONObject(i).getString("user"));
            portalAccountingMessage.setVre(jSONArray.getJSONObject(i).getString("vre"));
            portalAccountingMessage.setTime(jSONArray.getJSONObject(i).getString("time"));
            portalAccountingMessage.setId(jSONArray.getJSONObject(i).getString("Id"));
            BaseRecord baseRecord = (BaseRecord)clazz.newInstance();
            baseRecord.setDate(this.dateFormat.parse(jSONArray.getJSONObject(i).getString("date")));
            this.populateRecord(jSONArray.getJSONObject(i), baseRecord);
            portalAccountingMessage.addRecord(baseRecord);
            arrayList.add(portalAccountingMessage);
        }
        return arrayList;
    }

    private <TYPE extends BaseRecord> String selectQuery(Class<TYPE> clazz) {
        if (clazz.equals(LoginRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, LOGIN.message AS message FROM PORTALACCOUNTING,LOGIN WHERE PORTALACCOUNTING.type='LoginRecord' AND PORTALACCOUNTING.Id=LOGIN.Id";
        }
        if (clazz.equals(BrowseRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, BROWSE.browseBy AS browseBy, BROWSE.isDistinct AS isDistinct FROM PORTALACCOUNTING, BROWSE WHERE PORTALACCOUNTING.type='BrowseRecord' AND PORTALACCOUNTING.Id=BROWSE.Id";
        }
        if (clazz.equals(AdvancedSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ADVANCEDSEARCH.operator AS operator  FROM PORTALACCOUNTING,ADVANCEDSEARCH WHERE PORTALACCOUNTING.type='AdvancedSearchRecord' AND PORTALACCOUNTING.Id=ADVANCEDSEARCH.Id";
        }
        if (clazz.equals(SimpleSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, SIMPLESEARCH.termValue AS termValue FROM PORTALACCOUNTING,SIMPLESEARCH WHERE PORTALACCOUNTING.type='SimpleSearchRecord' AND PORTALACCOUNTING.Id=SIMPLESEARCH.Id";
        }
        if (clazz.equals(ContentRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, CONTENT.identifier AS identifier, CONTENT.name AS name  FROM  PORTALACCOUNTING, CONTENT WHERE PORTALACCOUNTING.type='ContentRecord' AND PORTALACCOUNTING.Id=CONTENT.Id";
        }
        if (clazz.equals(GenericRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GENERIC.message AS message  FROM  PORTALACCOUNTING, GENERIC WHERE PORTALACCOUNTING.type='GenericRecord' AND PORTALACCOUNTING.Id=GENERIC.Id";
        }
        if (clazz.equals(GoogleSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GOOGLESEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, GOOGLESEARCH WHERE PORTALACCOUNTING.type='GoogleSearchRecord' AND PORTALACCOUNTING.Id=GOOGLESEARCH.Id";
        }
        if (clazz.equals(QuickSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, QUICKSEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, QUICKSEARCH WHERE PORTALACCOUNTING.type='QuickSearchRecord' AND PORTALACCOUNTING.Id=QUICKSEARCH.Id";
        }
        if (clazz.equals(HLRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, HL.IDENTIFIER AS IDENTIFIER, HL.NAME AS NAME, HL.TYPE AS HL_TYPE, HL.SUBTYPE AS SUBTYPE FROM  PORTALACCOUNTING, HL WHERE PORTALACCOUNTING.type='HLRecord' AND PORTALACCOUNTING.Id=HL.Id";
        }
        if (clazz.equals(AISRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AIS.IDENTIFIER AS IDENTIFIER, AIS.NAME AS NAME, AIS.SUBTYPE AS SUBTYPE FROM PORTALACCOUNTING, AIS WHERE PORTALACCOUNTING.type='AISRecord' AND PORTALACCOUNTING.Id=AIS.Id";
        }
        if (clazz.equals(TSRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, TS.TITLE AS TITLE, TS.SUBTYPE AS SUBTYPE   FROM  PORTALACCOUNTING, TS WHERE PORTALACCOUNTING.type='TSRecord' AND PORTALACCOUNTING.Id=TS.Id";
        }
        if (clazz.equals(AnnotationRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ANNOTATION.NAME AS NAME, ANNOTATION.ACTION AS ACTION,ANNOTATION.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, ANNOTATION WHERE PORTALACCOUNTING.type='AnnotationRecord' AND PORTALACCOUNTING.Id=ANNOTATION.Id";
        }
        if (clazz.equals(ReportRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, REPORT.SUBTYPE AS SUBTYPE, REPORT.TEMPLATEID AS TEMPLATEID, REPORT.TEMPLATENAME AS TEMPLATENAME, REPORT.AUTHOR AS AUTHOR, REPORT.NAME AS NAME, REPORT.MIMETYPE AS MIMETYPE, REPORT.TYPE AS TYPE  FROM  PORTALACCOUNTING, REPORT WHERE PORTALACCOUNTING.type='ReportRecord' AND PORTALACCOUNTING.Id=REPORT.Id";
        }
        if (clazz.equals(DocumentWorkflowRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, DOCUMENTWORKFLOW.SUBTYPE AS SUBTYPE, DOCUMENTWORKFLOW.WORKFLOWID AS WORKFLOWID,DOCUMENTWORKFLOW.REPORTNAME AS REPORTNAME,DOCUMENTWORKFLOW.STATUS AS STATUS,DOCUMENTWORKFLOW.STEPNUMBER AS STEPNUMBER  FROM  PORTALACCOUNTING, DOCUMENTWORKFLOW WHERE PORTALACCOUNTING.type='DocumentWorkflowRecord' AND PORTALACCOUNTING.Id=DOCUMENTWORKFLOW.Id";
        }
        if (clazz.equals(WebAppRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WEBAPP.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, WEBAPP WHERE PORTALACCOUNTING.type='WebAppRecord' AND PORTALACCOUNTING.Id=WEBAPP.Id";
        }
        if (clazz.equals(WarRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WAR.SUBTYPE AS SUBTYPE,WAR.WARID AS WARID,WAR.WARNAME AS WARNAME,WAR.WEBAPPNAME AS WEBAPPNAME, WAR.WEBAPPVERSION AS WEBAPPVERSION, WAR.CATEGORY AS CATEGORY FROM  PORTALACCOUNTING, WAR WHERE PORTALACCOUNTING.type='WarRecord' AND PORTALACCOUNTING.Id=WAR.Id";
        }
        if (clazz.equals(AquamapsRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AQUAMAPS.TITLE AS TITLE, AQUAMAPS.AQUAMAPSTYPE AS AQUAMAPSTYPE,AQUAMAPS.SUBTYPE AS SUBTYPE,AQUAMAPS.SPECIESCOUNT AS SPECIESCOUNT ,AQUAMAPS.GIS AS GIS,AQUAMAPS.HSPECID AS HSPECID,AQUAMAPS.OBJECTID AS OBJECTID    FROM  PORTALACCOUNTING, AQUAMAPS WHERE PORTALACCOUNTING.type='AquamapsRecord' AND PORTALACCOUNTING.Id=AQUAMAPS.Id";
        }
        return "";
    }

    private String selectQuery(String string) {
        this.logger.debug((Object)("QUERY TYPE: " + string));
        if (string.equals("LoginRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, LOGIN.message AS message FROM PORTALACCOUNTING,LOGIN WHERE PORTALACCOUNTING.type='LoginRecord' AND PORTALACCOUNTING.Id=LOGIN.Id";
        }
        if (string.equals("BrowseRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, BROWSE.browseBy AS browseBy, BROWSE.isDistinct AS isDistinct FROM PORTALACCOUNTING, BROWSE WHERE PORTALACCOUNTING.type='BrowseRecord' AND PORTALACCOUNTING.Id=BROWSE.Id";
        }
        if (string.equals("AdvancedSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ADVANCEDSEARCH.operator AS operator  FROM PORTALACCOUNTING,ADVANCEDSEARCH WHERE PORTALACCOUNTING.type='AdvancedSearchRecord' AND PORTALACCOUNTING.Id=ADVANCEDSEARCH.Id";
        }
        if (string.equals("SimpleSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, SIMPLESEARCH.termValue AS termValue FROM PORTALACCOUNTING,SIMPLESEARCH WHERE PORTALACCOUNTING.type='SimpleSearchRecord' AND PORTALACCOUNTING.Id=SIMPLESEARCH.Id";
        }
        if (string.equals("ContentRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, CONTENT.identifier AS identifier, CONTENT.name AS name  FROM  PORTALACCOUNTING, CONTENT WHERE PORTALACCOUNTING.type='ContentRecord' AND PORTALACCOUNTING.Id=CONTENT.Id";
        }
        if (string.equals("GenericRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GENERIC.message AS message  FROM  PORTALACCOUNTING, GENERIC WHERE PORTALACCOUNTING.type='GenericRecord' AND PORTALACCOUNTING.Id=GENERIC.Id";
        }
        if (string.equals("GoogleSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GOOGLESEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, GOOGLESEARCH WHERE PORTALACCOUNTING.type='GoogleSearchRecord' AND PORTALACCOUNTING.Id=GOOGLESEARCH.Id";
        }
        if (string.equals("QuickSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, QUICKSEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, QUICKSEARCH WHERE PORTALACCOUNTING.type='QuickSearchRecord' AND PORTALACCOUNTING.Id=QUICKSEARCH.Id";
        }
        if (string.equals("HLRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, HL.IDENTIFIER AS IDENTIFIER, HL.NAME AS NAME, HL.TYPE AS HL_TYPE, HL.SUBTYPE AS SUBTYPE FROM  PORTALACCOUNTING, HL WHERE PORTALACCOUNTING.type='HLRecord' AND PORTALACCOUNTING.Id=HL.Id";
        }
        if (string.equals("AISRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AIS.IDENTIFIER AS IDENTIFIER, AIS.NAME AS NAME, AIS.SUBTYPE AS SUBTYPE FROM PORTALACCOUNTING, AIS WHERE PORTALACCOUNTING.type='AISRecord' AND PORTALACCOUNTING.Id=AIS.Id";
        }
        if (string.equals("TSRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, TS.TITLE AS TITLE, TS.SUBTYPE AS SUBTYPE   FROM  PORTALACCOUNTING, TS WHERE PORTALACCOUNTING.type='TSRecord' AND PORTALACCOUNTING.Id=TS.Id";
        }
        if (string.equals("AnnotationRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ANNOTATION.NAME AS NAME, ANNOTATION.ACTION AS ACTION,ANNOTATION.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, ANNOTATION WHERE PORTALACCOUNTING.type='AnnotationRecord' AND PORTALACCOUNTING.Id=ANNOTATION.Id";
        }
        if (string.equals("WebAppRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WEBAPP.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, WEBAPP WHERE PORTALACCOUNTING.type='WebAppRecord' AND PORTALACCOUNTING.Id=WEBAPP.Id";
        }
        if (string.equals("WarRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WAR.SUBTYPE AS SUBTYPE,WAR.WARID AS WARID,WAR.WARNAME AS WARNAME,WAR.WEBAPPNAME AS WEBAPPNAME, WAR.WEBAPPVERSION AS WEBAPPVERSION, WAR.CATEGORY AS CATEGORY FROM  PORTALACCOUNTING, WAR WHERE PORTALACCOUNTING.type='WarRecord' AND PORTALACCOUNTING.Id=WAR.Id";
        }
        if (string.equals("ReportRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, REPORT.SUBTYPE AS SUBTYPE, REPORT.TEMPLATEID AS TEMPLATEID, REPORT.TEMPLATENAME AS TEMPLATENAME, REPORT.AUTHOR AS AUTHOR, REPORT.NAME AS NAME, REPORT.MIMETYPE AS MIMETYPE, REPORT.TYPE AS TYPE  FROM  PORTALACCOUNTING, REPORT WHERE PORTALACCOUNTING.type='ReportRecord' AND PORTALACCOUNTING.Id=REPORT.Id";
        }
        if (string.equals("DocumentWorkflowRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, DOCUMENTWORKFLOW.SUBTYPE AS SUBTYPE, DOCUMENTWORKFLOW.WORKFLOWID AS WORKFLOWID,DOCUMENTWORKFLOW.REPORTNAME AS REPORTNAME,DOCUMENTWORKFLOW.STATUS AS STATUS,DOCUMENTWORKFLOW.STEPNUMBER AS STEPNUMBER  FROM  PORTALACCOUNTING, DOCUMENTWORKFLOW WHERE PORTALACCOUNTING.type='DocumentWorkflowRecord' AND PORTALACCOUNTING.Id=DOCUMENTWORKFLOW.Id";
        }
        if (string.equals("AquamapsRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AQUAMAPS.TITLE AS TITLE, AQUAMAPS.AQUAMAPSTYPE AS AQUAMAPSTYPE,AQUAMAPS.SUBTYPE AS SUBTYPE,AQUAMAPS.SPECIESCOUNT AS SPECIESCOUNT ,AQUAMAPS.GIS AS GIS,AQUAMAPS.HSPECID AS HSPECID,AQUAMAPS.OBJECTID AS OBJECTID    FROM  PORTALACCOUNTING, AQUAMAPS WHERE PORTALACCOUNTING.type='AquamapsRecord' AND PORTALACCOUNTING.Id=AQUAMAPS.Id";
        }
        return "";
    }

    private <TYPE extends BaseRecord> TYPE populateRecord(JSONObject jSONObject, TYPE TYPE) throws JSONException {
        if (TYPE instanceof LoginRecord) {
            ((LoginRecord)TYPE).setMessage(jSONObject.getString("message"));
        } else if (TYPE instanceof ContentRecord) {
            ((ContentRecord)TYPE).setContentId(jSONObject.getString("identifier"));
            ((ContentRecord)TYPE).setContentName(jSONObject.getString("name"));
        } else if (TYPE instanceof BrowseRecord) {
            ((BrowseRecord)TYPE).setBrowseBy(jSONObject.getString("browseBy"));
            ((BrowseRecord)TYPE).setBrowseBy(jSONObject.getString("isDistinct"));
        } else if (TYPE instanceof AdvancedSearchRecord) {
            ((AdvancedSearchRecord)TYPE).setOperator(AdvancedSearchRecord.OperatorType.valueOf((String)jSONObject.getString("operator")));
        } else if (TYPE instanceof SimpleSearchRecord) {
            ((SimpleSearchRecord)TYPE).setTerm(jSONObject.getString("termValue"));
        } else if (TYPE instanceof QuickSearchRecord) {
            ((QuickSearchRecord)TYPE).setTerm(jSONObject.getString("termValue"));
        } else if (TYPE instanceof GoogleSearchRecord) {
            ((GoogleSearchRecord)TYPE).setTerm(jSONObject.getString("termValue"));
        } else if (TYPE instanceof HLRecord) {
            ((HLRecord)TYPE).setHLsubType(HLRecord.HLSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((HLRecord)TYPE).setID(jSONObject.getString("IDENTIFIER"));
            ((HLRecord)TYPE).setType(jSONObject.getString("HL_TYPE"));
            ((HLRecord)TYPE).setName(jSONObject.getString("NAME"));
        } else if (TYPE instanceof AISRecord) {
            ((AISRecord)TYPE).setAISsubType(AISRecord.AISSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((AISRecord)TYPE).setID(jSONObject.getString("IDENTIFIER"));
            ((AISRecord)TYPE).setName(jSONObject.getString("NAME"));
        } else if (TYPE instanceof TSRecord) {
            ((TSRecord)TYPE).setTSsubType(TSRecord.TSSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((TSRecord)TYPE).setTitle(jSONObject.getString("TITLE"));
        } else if (TYPE instanceof WebAppRecord) {
            ((WebAppRecord)TYPE).setSubType(WebAppRecord.WebAppSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
        } else if (TYPE instanceof WarRecord) {
            ((WarRecord)TYPE).setSubType(WarRecord.WarSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((WarRecord)TYPE).setWarId(jSONObject.getString("WARID"));
            ((WarRecord)TYPE).setWarName(jSONObject.getString("WARNAME"));
            ((WarRecord)TYPE).setAppName(jSONObject.getString("WEBAPPNAME"));
            ((WarRecord)TYPE).setAppVersion(jSONObject.getString("WEBAPPVERSION"));
            ((WarRecord)TYPE).setCategory(jSONObject.getString("CATEGORY"));
        } else if (TYPE instanceof AnnotationRecord) {
            ((AnnotationRecord)TYPE).setAnnotationSubType(AnnotationRecord.AnnotationSubType.valueOf((String)jSONObject.getString("ACTION")));
            ((AnnotationRecord)TYPE).setAnnotationName(jSONObject.getString("name"));
            ((AnnotationRecord)TYPE).setAnnotationType(jSONObject.getString("SUBTYPE"));
        } else if (TYPE instanceof ReportRecord) {
            ((ReportRecord)TYPE).setAuthor(jSONObject.getString("AUTHOR"));
            ((ReportRecord)TYPE).setMimetype(jSONObject.getString("MIMETYPE"));
            ((ReportRecord)TYPE).setName(jSONObject.getString("name"));
            ((ReportRecord)TYPE).setSubType(ReportRecord.ReportSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((ReportRecord)TYPE).setTemplateID(jSONObject.getString("TEMPLATEID"));
            ((ReportRecord)TYPE).setTemplateName(jSONObject.getString("TEMPLATENAME"));
            ((ReportRecord)TYPE).setType(jSONObject.getString("***TYPE***"));
        } else if (TYPE instanceof DocumentWorkflowRecord) {
            ((DocumentWorkflowRecord)TYPE).setSubType(DocumentWorkflowRecord.WorkflowSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((DocumentWorkflowRecord)TYPE).setReportname(jSONObject.getString("REPORTNAME"));
            ((DocumentWorkflowRecord)TYPE).setStatus(jSONObject.getString("STATUS"));
            ((DocumentWorkflowRecord)TYPE).setStepsNumber(jSONObject.getString("STEPNUMBER"));
            ((DocumentWorkflowRecord)TYPE).setWorkflowid(jSONObject.getString("WORKFLOWID"));
        } else if (TYPE instanceof AquamapsRecord) {
            ((AquamapsRecord)TYPE).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.valueOf((String)jSONObject.getString("SUBTYPE")));
            ((AquamapsRecord)TYPE).setGis(Boolean.parseBoolean(jSONObject.getString("GIS")));
            ((AquamapsRecord)TYPE).setHspecId(jSONObject.getString("HSPECID"));
            ((AquamapsRecord)TYPE).setObjectID(jSONObject.getString("OBJECTID"));
            ((AquamapsRecord)TYPE).setSpeciesCount(Long.parseLong(jSONObject.getString("SPECIESCOUNT")));
            ((AquamapsRecord)TYPE).setTitle(jSONObject.getString("TITLE"));
            ((AquamapsRecord)TYPE).setType(jSONObject.getString("AQUAMAPSTYPE"));
        }
        return TYPE;
    }
}

