/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.AdvancedSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.common.messages.records.AdvancedSearchRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;

public class AdvancedSearchEntry
extends LogEntry {
    private static final long serialVersionUID = 1L;
    private String operator;
    private HashMap<String, String> collections = null;
    private HashMap<String, String> terms = null;
    private StringTokenizer tokenizer = null;

    public AdvancedSearchEntry(String line) throws ParseException {
        this.line = line;
        this.record = new AdvancedSearchRecord();
        this.entryType = AccessLogParser.EntryType.Advanced_Search;
        this.parse();
    }

    public BaseRecord fillRecord() {
        this.collections = new HashMap();
        this.terms = new HashMap();
        this.tokenizer = new StringTokenizer(this.getMessage().getMessage(), "|");
        while (this.tokenizer.hasMoreElements()) {
            String tok = this.tokenizer.nextToken();
            if (tok.contains(SearchAndBrowseTokens.collectionName.tokens)) {
                String[] col = Message.getDetails((String)tok);
                this.collections.put(col[0], col[1]);
                continue;
            }
            if (tok.contains(SearchAndBrowseTokens.term.tokens)) {
                String[] term = Message.getDetails((String)tok);
                this.terms.put(term[1], term[0]);
                continue;
            }
            if (!tok.contains(SearchAndBrowseTokens.operator.tokens)) continue;
            this.operator = Message.getValue((String)tok);
        }
        this.record.setDate(this.getDate());
        ((AdvancedSearchRecord)this.record).setTerms(this.terms);
        ((AdvancedSearchRecord)this.record).setCollections(this.collections);
        ((AdvancedSearchRecord)this.record).setOperator(AdvancedSearchRecord.OperatorType.valueOf((String)this.operator));
        return this.record;
    }
}

