/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.accounting.portal.logparser.entry.WorkflowDocumentEntry;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.DocumentWorkflowRecord;

public class WorkflowDocumentEntry
extends LogEntry {
    private static final long serialVersionUID = 1252202428920233522L;
    private StringTokenizer tokenizer = null;
    private String[] workflowDocumentsEntry = new String[3];

    public WorkflowDocumentEntry(String line, AccessLogParser.EntryType type) throws ParseException {
        this.line = line;
        this.entryType = type;
        this.record = new DocumentWorkflowRecord();
        this.parse();
    }

    public BaseRecord fillRecord() {
        this.tokenizer = new StringTokenizer(this.message.getMessage(), "|");
        while (this.tokenizer.hasMoreElements()) {
            String tok = this.tokenizer.nextToken();
            if (tok.contains(WorkflowDocumentTokens.WORKFLOWID.tokens)) {
                this.workflowDocumentsEntry[0] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(WorkflowDocumentTokens.WorkflowDocuementName.tokens)) {
                this.workflowDocumentsEntry[1] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(WorkflowDocumentTokens.STATUS.tokens)) {
                this.workflowDocumentsEntry[2] = Message.getValue((String)tok);
                continue;
            }
            if (!tok.contains(WorkflowDocumentTokens.STEPS_NO.tokens)) continue;
            this.workflowDocumentsEntry[2] = Message.getValue((String)tok);
        }
        this.record.setDate(this.getDate());
        ((DocumentWorkflowRecord)this.record).setSubType(DocumentWorkflowRecord.WorkflowSubType.valueOf((String)this.getEntryType().name()));
        ((DocumentWorkflowRecord)this.record).setReportname(this.workflowDocumentsEntry[1]);
        ((DocumentWorkflowRecord)this.record).setWorkflowid(this.workflowDocumentsEntry[0]);
        if (this.getEntryType().compareTo((Enum)AccessLogParser.EntryType.CREATED_WORKFLOWREPORT_OUTPUT) == 0) {
            ((DocumentWorkflowRecord)this.record).setStepsNumber(this.workflowDocumentsEntry[2]);
        } else {
            ((DocumentWorkflowRecord)this.record).setStatus(this.workflowDocumentsEntry[2]);
        }
        return this.record;
    }
}

