/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.accounting.portal.logparser.entry.StatisticalManagerEntry;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.StatisticalManagerRecord;

public class StatisticalManagerEntry
extends LogEntry {
    private static final long serialVersionUID = 1L;
    private String[] smEntry = new String[5];

    public StatisticalManagerEntry(String line, AccessLogParser.EntryType type) throws ParseException {
        this.line = line;
        this.entryType = type;
        this.record = new StatisticalManagerRecord();
        this.parse();
    }

    public BaseRecord fillRecord() {
        this.tokenizer = new StringTokenizer(this.message.getMessage(), "|");
        while (this.tokenizer.hasMoreElements()) {
            String tok = this.tokenizer.nextToken();
            if (tok.contains(SMTokens.ALGORITHM_NAME.tokens)) {
                this.smEntry[0] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(SMTokens.EXECUTION_OUTCOME.tokens)) {
                this.smEntry[1] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(SMTokens.EXECUTION_TIME.tokens)) {
                this.smEntry[2] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(SMTokens.FILE_NAME.tokens)) {
                this.smEntry[3] = Message.getValue((String)tok);
                continue;
            }
            if (!tok.contains(SMTokens.FILE_TYPE.tokens)) continue;
            this.smEntry[4] = Message.getValue((String)tok);
        }
        this.record.setDate(this.getDate());
        ((StatisticalManagerRecord)this.record).setType(StatisticalManagerRecord.StatisticalManagerSubType.valueOf((String)this.getEntryType().name()));
        if (((StatisticalManagerRecord)this.record).getType().compareTo((Enum)StatisticalManagerRecord.StatisticalManagerSubType.STATISTICALMANAGER_EXECUTION) == 0) {
            ((StatisticalManagerRecord)this.record).setAlgorithmName(this.smEntry[0]);
            ((StatisticalManagerRecord)this.record).setExecutionOutcome(this.smEntry[1]);
            ((StatisticalManagerRecord)this.record).setExecutionSecondsTime(Long.parseLong(this.smEntry[2]));
        } else {
            ((StatisticalManagerRecord)this.record).setFileName(this.smEntry[3]);
            ((StatisticalManagerRecord)this.record).setFileType(this.smEntry[4]);
        }
        return this.record;
    }
}

