/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.gcube.common.accounting.node.logparser.LogEntry;
import org.gcube.common.accounting.node.logparser.RIInvocationParser;
import org.gcube.common.accounting.node.persistence.PersistenceAdapter;
import org.gcube.common.accounting.node.persistence.RIAccountingData;
import org.gcube.common.accounting.node.util.DateInterval;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.messages.NodeAccountingMessage;
import org.gcube.messaging.common.messages.records.IntervalRecord;

public class Util {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DAY = "yyyy-MM-dd";
    public static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat format_day = new SimpleDateFormat("yyyy-MM-dd");
    GCUBELog logger = null;

    public Util(GCUBELog gCUBELog) {
        this.logger = gCUBELog;
    }

    protected ArrayList<NodeAccountingMessage<IntervalRecord>> groupAccountingMessages(ArrayList<LogEntry> arrayList, DateInterval dateInterval) {
        Object object;
        ArrayList<NodeAccountingMessage<IntervalRecord>> arrayList2 = new ArrayList<NodeAccountingMessage<IntervalRecord>>();
        HashMap hashMap = new HashMap();
        for (LogEntry logEntry : arrayList) {
            HashMap hashMap2 = null;
            HashMap<String, Object> hashMap3 = null;
            object = null;
            hashMap2 = (HashMap)hashMap.get(logEntry.getScope());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            if ((hashMap3 = (HashMap)hashMap2.get(logEntry.getInfo().toString())) == null) {
                hashMap3 = new HashMap<String, Object>();
            }
            if ((object = (InvocationInfo)hashMap3.get(logEntry.getInfo().getCallerIP())) == null) {
                object = new InvocationInfo();
            }
            ((InvocationInfo)object).addInvocation(logEntry.getInvocationTime());
            ((InvocationInfo)object).setTime(logEntry.getTime());
            ((InvocationInfo)object).setIP(logEntry.getInfo().getCallerIP());
            hashMap3.put(logEntry.getInfo().getCallerIP(), object);
            hashMap2.put(logEntry.getInfo().toString(), hashMap3);
            hashMap.put(logEntry.getScope(), hashMap2);
        }
        for (LogEntry logEntry : hashMap.keySet()) {
            for (HashMap<String, Object> hashMap3 : ((HashMap)hashMap.get(logEntry)).keySet()) {
                object = new NodeAccountingMessage();
                object.setCallScope(logEntry.toString());
                object.setServiceClass(Util.getClazz(hashMap3));
                object.setServiceName(Util.getName(hashMap3));
                for (String string : ((HashMap)((HashMap)hashMap.get(logEntry)).get(hashMap3)).keySet()) {
                    IntervalRecord intervalRecord = new IntervalRecord(Long.valueOf(dateInterval.getInterval() / 1000L));
                    intervalRecord.setStartInterval(dateInterval.getStartDate().getTime());
                    intervalRecord.setEndInterval(dateInterval.getEndDate().getTime());
                    intervalRecord.setAverageInvocationTime(Double.valueOf(((InvocationInfo)((HashMap)((HashMap)hashMap.get(logEntry)).get(hashMap3)).get(string)).getAverageInvocationTime()));
                    intervalRecord.setInvocationNumber(Long.valueOf(((InvocationInfo)((HashMap)((HashMap)hashMap.get(logEntry)).get(hashMap3)).get(string)).getInvocationCount()));
                    intervalRecord.setIP(string);
                    object.setTime(((InvocationInfo)((HashMap)((HashMap)hashMap.get(logEntry)).get(hashMap3)).get(string)).getTime());
                    object.setRecord(string, intervalRecord);
                }
                arrayList2.add((NodeAccountingMessage<IntervalRecord>)object);
            }
        }
        return arrayList2;
    }

    public ArrayList<DateInterval> generateDateIntervals(PersistenceAdapter persistenceAdapter, Long l) {
        ArrayList<DateInterval> arrayList = new ArrayList<DateInterval>();
        long l2 = l * 1000L;
        Calendar calendar = null;
        calendar = persistenceAdapter.getLastUpdate();
        if (calendar == null) {
            arrayList.add(new DateInterval(l2));
        } else {
            long l3 = calendar.getTimeInMillis();
            long l4 = Calendar.getInstance().getTimeInMillis();
            long l5 = (l4 - l3) / l2;
            if (l5 == 0L) {
                l5 = 1L;
            }
            long l6 = l3;
            Calendar calendar2 = Calendar.getInstance();
            Calendar calendar3 = Calendar.getInstance();
            int n = 0;
            while ((long)n < l5) {
                calendar2.setTime(new Date(l6));
                calendar3.setTime(new Date(l6 + l2));
                arrayList.add(new DateInterval(calendar2, calendar3, l2));
                l6 += l2;
                ++n;
            }
        }
        for (DateInterval dateInterval : arrayList) {
            this.logger.debug((Object)("Generated Date Interval from " + dateInterval.getStartDateAsString() + " to " + dateInterval.getEndDateAsString()));
        }
        return arrayList;
    }

    public HashMap<File, ArrayList<DateInterval>> matchIntervalsWithLogFiles(File[] fileArray, ArrayList<DateInterval> arrayList) {
        HashMap<File, ArrayList<DateInterval>> hashMap = new HashMap<File, ArrayList<DateInterval>>();
        if (fileArray == null || fileArray.length == 0) {
            this.logger.debug((Object)"No Log Files to Parse");
            return hashMap;
        }
        for (DateInterval dateInterval : arrayList) {
            ArrayList<DateInterval> arrayList2 = null;
            File file = null;
            if (dateInterval.getStartDateAsShortString().compareTo(format_day.format(Calendar.getInstance().getTime())) == 0) {
                for (File file2 : fileArray) {
                    if (!file2.getAbsolutePath().endsWith("access.log")) continue;
                    file = file2;
                    break;
                }
            } else {
                for (File file2 : fileArray) {
                    if (!file2.getAbsolutePath().endsWith("access.log." + dateInterval.getStartDateAsShortString())) continue;
                    file = file2;
                    break;
                }
                if (file == null) {
                    for (File file2 : fileArray) {
                        if (!file2.getAbsolutePath().endsWith("access.log")) continue;
                        file = file2;
                        break;
                    }
                }
            }
            if (file == null) {
                this.logger.debug((Object)("NO log file found for the interval " + dateInterval.getStartDateAsString() + "/" + dateInterval.getEndDateAsString()));
                continue;
            }
            arrayList2 = hashMap.get(file);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
            }
            this.logger.debug((Object)("Adding interval " + dateInterval.getStartDateAsString() + "/" + dateInterval.getEndDateAsString() + " to file " + file.getAbsolutePath()));
            arrayList2.add(dateInterval);
            hashMap.put(file, arrayList2);
        }
        return hashMap;
    }

    private ArrayList<NodeAccountingMessage<IntervalRecord>> filterMessage(ArrayList<NodeAccountingMessage<IntervalRecord>> arrayList, String string, String string2, String string3) {
        if (arrayList == null) {
            return new ArrayList<NodeAccountingMessage<IntervalRecord>>();
        }
        ArrayList<NodeAccountingMessage<IntervalRecord>> arrayList2 = new ArrayList<NodeAccountingMessage<IntervalRecord>>();
        for (NodeAccountingMessage<IntervalRecord> nodeAccountingMessage : arrayList) {
            if (nodeAccountingMessage.getCallScope().compareTo(string3) != 0 || nodeAccountingMessage.getServiceClass().compareTo(string2) != 0 || nodeAccountingMessage.getServiceName().compareTo(string) != 0) continue;
            arrayList2.add(nodeAccountingMessage);
        }
        return arrayList2;
    }

    private RIAccountingData updateDataFromMessage(NodeAccountingMessage<IntervalRecord> nodeAccountingMessage, RIAccountingData rIAccountingData) {
        if (nodeAccountingMessage == null) {
            return rIAccountingData;
        }
        Double d = new Double(0.0);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            for (Object object : nodeAccountingMessage.getRecords().values()) {
                rIAccountingData.addCalls(object.getInvocationNumber());
                rIAccountingData.getTopCallerData().addCallerInfo(object.getIP(), object.getInvocationNumber());
                d = d + (double)object.getInvocationNumber().longValue();
                arrayList.add(object.getAverageInvocationTime());
            }
            Object object = new Double(0.0);
            for (Double d2 : arrayList) {
                object = (Double)object + d2;
            }
            rIAccountingData.getAvgCallsNumber().addStatistics(d);
            if (arrayList.size() != 0) {
                rIAccountingData.getAvgInvocationTime().addStatistics((Double)object / (double)arrayList.size());
            } else {
                rIAccountingData.getAvgInvocationTime().addStatistics(new Double(0.0));
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"ERROR updating Accounting info from Message", (Throwable)exception);
        }
        return rIAccountingData;
    }

    public void updateAccoutingInfo(ArrayList<NodeAccountingMessage<IntervalRecord>> arrayList, PersistenceAdapter persistenceAdapter, DateInterval dateInterval) throws Exception {
        Object object;
        for (String string : persistenceAdapter.getMap().keySet()) {
            object = persistenceAdapter.getMap().get(string);
            for (String string2 : ((HashMap)object).keySet()) {
                try {
                    RIAccountingData rIAccountingData = ((HashMap)object).get(string2);
                    ArrayList<NodeAccountingMessage<IntervalRecord>> arrayList2 = this.filterMessage(arrayList, rIAccountingData.getServiceName(), rIAccountingData.getServiceClass(), string2);
                    if (arrayList2.size() > 0) {
                        for (NodeAccountingMessage<IntervalRecord> nodeAccountingMessage : arrayList2) {
                            rIAccountingData = this.updateDataFromMessage(nodeAccountingMessage, rIAccountingData);
                        }
                    } else {
                        rIAccountingData.getAvgCallsNumber().addStatistics(new Double(0.0));
                        rIAccountingData.getAvgInvocationTime().addStatistics(rIAccountingData.getAvgInvocationTime().getStatistics(new Long(0L)));
                        rIAccountingData.getTopCallerData().addCallerInfo("N/A", new Long(0L));
                    }
                    if (arrayList != null) {
                        arrayList.removeAll(arrayList2);
                    }
                    ((HashMap)object).put(string2, rIAccountingData);
                }
                catch (Exception exception) {
                    this.logger.error((Object)("ERROR updating Accounting info for service " + string + " in scope " + string2), (Throwable)exception);
                }
            }
            persistenceAdapter.getMap().put(string, (HashMap<String, RIAccountingData>)object);
        }
        if (arrayList != null) {
            for (NodeAccountingMessage nodeAccountingMessage : arrayList) {
                PersistenceAdapter persistenceAdapter2 = persistenceAdapter;
                persistenceAdapter2.getClass();
                object = persistenceAdapter2.new PersistenceAdapter.MapKey<String, String>(nodeAccountingMessage.getServiceClass(), nodeAccountingMessage.getServiceName()).getKey();
                try {
                    HashMap<String, RIAccountingData> hashMap = null;
                    hashMap = persistenceAdapter.getMap().get(object);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, RIAccountingData>();
                    }
                    RIAccountingData rIAccountingData = new RIAccountingData(persistenceAdapter.getInterval());
                    rIAccountingData.setServiceClass(nodeAccountingMessage.getServiceClass());
                    rIAccountingData.setServiceName(nodeAccountingMessage.getServiceName());
                    RIAccountingData rIAccountingData2 = this.updateDataFromMessage((NodeAccountingMessage<IntervalRecord>)nodeAccountingMessage, rIAccountingData);
                    hashMap.put(nodeAccountingMessage.getCallScope(), rIAccountingData2);
                    persistenceAdapter.getMap().put((String)object, hashMap);
                }
                catch (Exception exception) {
                    this.logger.error((Object)("ERROR updating Accounting info for service " + (String)object + " in scope " + nodeAccountingMessage.getCallScope()), (Throwable)exception);
                }
            }
        }
        persistenceAdapter.setLastUpdate(dateInterval.getEndDate());
        persistenceAdapter.store();
    }

    public ArrayList<NodeAccountingMessage<IntervalRecord>> createAccountingInfo(File file, DateInterval dateInterval) throws IOException, Exception {
        this.logger.debug((Object)("Parsing Node Log file" + file.getAbsolutePath()));
        RIInvocationParser rIInvocationParser = null;
        try {
            rIInvocationParser = new RIInvocationParser(file.getAbsolutePath(), dateInterval);
            rIInvocationParser.parse();
        }
        catch (IOException iOException) {
            this.logger.error((Object)"Error Parsing Node Log file", (Throwable)iOException);
            throw iOException;
        }
        catch (ParseException parseException) {
            this.logger.error((Object)"Error Parsing Node Log file", (Throwable)parseException);
            throw parseException;
        }
        if (rIInvocationParser.getEntryList().size() == 0) {
            this.logger.debug((Object)"No data to parse in the given interval");
            return null;
        }
        return this.groupAccountingMessages(rIInvocationParser.getEntryList(), dateInterval);
    }

    public static String getClazz(String string) {
        return string.substring(0, string.indexOf("_"));
    }

    public static String getName(String string) {
        return string.substring(string.indexOf("_") + 1);
    }

    private class InvocationInfo {
        private long invocationCount;
        private double averageInvocationTime;
        private String time;
        private String IP;

        public double getAverageInvocationTime() {
            return this.averageInvocationTime / (double)this.invocationCount;
        }

        public long getInvocationCount() {
            return this.invocationCount;
        }

        public void addInvocation(Double d) {
            ++this.invocationCount;
            this.averageInvocationTime += d.doubleValue();
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String string) {
            this.time = string;
        }

        public String getIP() {
            return this.IP;
        }

        public void setIP(String string) {
            this.IP = string;
        }
    }
}

