/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.ISCacheMBean;
import org.gcube.informationsystem.cache.Srv;
import org.gcube.informationsystem.cache.SrvRegistry;

public class ISCache
implements ISCacheMBean {
    private SrvRegistry registry = null;
    private GCUBELog log = new GCUBELog(ISCache.class);

    public ISCache(GCUBEScope scope) {
        this.registry = new SrvRegistry(scope);
    }

    public Srv[] getSrvs() {
        return this.getRegistry().getSrvs().toArray(new Srv[0]);
    }

    @Override
    public EndpointReference[] getEPRsFor(Srv srv) throws Exception {
        return this.getRegistry().getEPRsFor(srv);
    }

    @Override
    public EndpointReference[] getEPRsFor(String srvClass, String srvName) throws Exception {
        return this.getEPRsFor(new Srv(srvClass, srvName));
    }

    @Override
    public EndpointReference[] getEPRsFor(Srv srv, String srvType) throws Exception {
        return this.getRegistry().getEPRsFor(srv, srvType);
    }

    @Override
    public EndpointReference[] getEPRsFor(String srvClass, String srvName, String srvType) throws Exception {
        return this.getRegistry().getEPRsFor(srvClass, srvName, srvType);
    }

    @Override
    public int getSrvNumber() {
        return this.getRegistry().getSrvs().size();
    }

    @Override
    public String[] getSrvsStr() {
        HashSet<String> vec = new HashSet<String>();
        Iterator<Srv> s = this.getRegistry().getSrvs().iterator();
        while (s.hasNext()) {
            vec.add(s.next().toString());
        }
        return vec.toArray(new String[0]);
    }

    @Override
    public boolean addFilterCriterion(String srvClass, String srvName, String srvType, String critVar, String critVal) throws Exception {
        return this.addFilterCriterion(new Srv(srvClass, srvName), srvType, critVar, critVal);
    }

    @Override
    public boolean addFilterCriterion(Srv srv, String srvType, String critVar, String critVal) throws Exception {
        HashMap<String, String> h;
        if (!Srv.isServiceTypeValid(srvType)) {
            throw new Exception("Service Type '" + srvType + "' is not valid.");
        }
        Srv actualSrv = this.getRegistry().getService(srv);
        if (actualSrv == null) {
            this.getRegistry().addService(srv);
            actualSrv = this.getRegistry().getService(srv);
            if (actualSrv == null) {
                throw new Exception("Got null service, even after I explicitly added!");
            }
        }
        if ((h = actualSrv.getFilterCriteria().get(srvType)) == null) {
            h = new HashMap();
        }
        boolean ret = false;
        if (h.put(critVar, critVal) == null) {
            ret = true;
        }
        actualSrv.getFilterCriteria().put(srvType, h);
        this.log.debug((Object)"Forcing service update");
        actualSrv.forceRefreshService();
        this.log.debug((Object)"Service update finished");
        return ret;
    }

    @Override
    public boolean delAllFilterCriterion(String srvClass, String srvName, String srvType) throws Exception {
        return this.delAllFilterCriterion(new Srv(srvClass, srvName), srvType);
    }

    @Override
    public boolean delAllFilterCriterion(Srv srv, String srvType) throws Exception {
        if (!Srv.isServiceTypeValid(srvType)) {
            throw new Exception("Service Type '" + srvType + "' is not valid.");
        }
        return this.getRegistry().getService(srv).getFilterCriteria().remove(srvType) != null;
    }

    @Override
    public boolean delFilterCriterion(String srvClass, String srvName, String srvType, String critVar) throws Exception {
        return this.delFilterCriterion(new Srv(srvClass, srvName), srvType, critVar);
    }

    @Override
    public boolean delFilterCriterion(Srv srv, String srvType, String critVar) throws Exception {
        if (!Srv.isServiceTypeValid(srvType)) {
            throw new Exception("Service Type '" + srvType + "' is not valid.");
        }
        HashMap<String, String> h = this.getRegistry().getService(srv).getFilterCriteria().get(srvType);
        if (h == null || h.size() == 0) {
            return false;
        }
        return h.remove(critVar) != null;
    }

    @Override
    public String[] getAllFilterCriteria(String srvClass, String srvName, String srvType) throws Exception {
        return this.getAllFilterCriteria(new Srv(srvClass, srvName), srvType);
    }

    @Override
    public String[] getAllFilterCriteria(Srv srv, String srvType) throws Exception {
        if (!Srv.isServiceTypeValid(srvType)) {
            throw new Exception("Service Type '" + srvType + "' is not valid.");
        }
        HashMap<String, String> h = this.getRegistry().getService(srv).getFilterCriteria().get(srvType);
        if (h == null) {
            return new String[0];
        }
        Iterator<Map.Entry<String, String>> it = h.entrySet().iterator();
        Vector<String> vec = new Vector<String>();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String var = entry.getKey();
            String val = entry.getValue();
            vec.add(var + ":" + val);
        }
        return vec.toArray(new String[0]);
    }

    public void setRegistry(SrvRegistry registry) {
        this.registry = registry;
    }

    public SrvRegistry getRegistry() {
        return this.registry;
    }
}

