/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.context;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.gcube.common.core.contexts.GHNContext;

public class ISPublisherContext {
    public static final String REGISTRY_CHANNEL_TIMEOUT_PROP_NAME = "REGISTRY_CHANNEL_TIMEOUT";
    public static final String COLLECTOR_CHANNEL_TIMEOUT_PROP_NAME = "COLLECTOR_CHANNEL_TIMEOUT";
    public static final String BULK_PUBLICATIONS_INTERVAL_PROP_NAME = "BULK_PUBLICATIONS_INTERVAL";
    public static final String MAX_PARALLEL_REGISTRATIONS_PROP_NAME = "MAX_PARALLEL_REGISTRATIONS";
    public static final String RESOURCE_PUBLICATION_MAX_ATTEMPTS_PROP_NAME = "RESOURCE_PUBLICATION_MAX_ATTEMPTS";
    private static final String PROPERTIES_RESOURCE = "ISPublisher.properties";
    private static Properties properties = new Properties();
    private static ISPublisherContext context = null;

    private ISPublisherContext() throws IOException {
        try {
            properties.load(new FileInputStream(GHNContext.getContext().getFile(PROPERTIES_RESOURCE, new boolean[0])));
        }
        catch (Exception e) {
            properties.load(this.getClass().getResourceAsStream(PROPERTIES_RESOURCE));
        }
    }

    public static ISPublisherContext getContext() throws IOException {
        if (context == null) {
            context = new ISPublisherContext();
        }
        return context;
    }

    public Object getProperty(String name) throws NoSuchProperty {
        if (properties.get(name) == null) {
            throw new NoSuchProperty();
        }
        return properties.get(name);
    }

    public static void main(String[] args) {
        try {
            String parallel = (String)ISPublisherContext.getContext().getProperty(MAX_PARALLEL_REGISTRATIONS_PROP_NAME);
            System.out.println("MAX_PARALLEL_REGISTRATIONS=" + parallel);
            String timeout = (String)ISPublisherContext.getContext().getProperty(REGISTRY_CHANNEL_TIMEOUT_PROP_NAME);
            System.out.println("REGISTRY_CHANNEL_TIMEOUT=" + timeout);
            String attempts = (String)ISPublisherContext.getContext().getProperty(RESOURCE_PUBLICATION_MAX_ATTEMPTS_PROP_NAME);
            System.out.println("RESOURCE_PUBLICATION_MAX_ATTEMPTS=" + attempts);
        }
        catch (NoSuchProperty e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static class NoSuchProperty
    extends Exception {
        private static final long serialVersionUID = -6576162414295412552L;
    }
}

