/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.gcube.common.core.state.GCUBEPublicationProfile;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.state.GCUBEWSResourcePropertySet;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.utils.AnyHelper;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

final class WSRPDocument {
    private static final GCUBELog logger = new GCUBELog(WSRPDocument.class);
    private GCUBEWSResource resource;
    private PublicationProfileParser parser;
    private int pollingInterval = 600;
    private List<QName> resourcePropertyNames;

    WSRPDocument(GCUBEWSResource resource) throws Exception {
        this.resource = resource;
        this.parser = new PublicationProfileParser(resource.getPorttypeContext().getPublicationProfile());
        this.parser.parse();
        this.initializetResourcePropertyNames();
        this.pollingInterval = this.parser.getPollingInterval();
    }

    void initializetResourcePropertyNames() throws Exception {
        this.resourcePropertyNames = new ArrayList<QName>();
        GCUBEWSResourcePropertySet rps = this.resource.getResourcePropertySet();
        if (rps == null) {
            throw new Exception("Null property set from " + this.getName());
        }
        try {
            List<QName> serviceRPNames = this.parser.getRPNames();
            for (QName name : serviceRPNames) {
                logger.trace((Object)("found RP " + name));
                this.resourcePropertyNames.add(name);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to retrieve the RP names from " + this.getName()), (Throwable)e);
            throw e;
        }
    }

    Map<QName, SOAPElement[]> getResourcePropertyValues() throws Exception {
        LinkedHashMap<QName, SOAPElement[]> resourcePropertyValues = new LinkedHashMap<QName, SOAPElement[]>();
        GCUBEWSResourcePropertySet rps = this.resource.getResourcePropertySet();
        for (QName name : this.resourcePropertyNames) {
            try {
                ResourceProperty rp = rps.get(name);
                if (rp == null) {
                    logger.warn((Object)("Null value for RP " + name));
                    continue;
                }
                resourcePropertyValues.put(name, rp.toSOAPElements());
            }
            catch (Exception e) {
                logger.error((Object)("Failed to retrieve the value of RP " + name), (Throwable)e);
            }
        }
        for (String name : GCUBEWSResourcePropertySet.getSystemRPNames()) {
            try {
                ResourceProperty rp = rps.getSystemRP(name);
                if (rp == null) {
                    logger.warn((Object)("Null value for RP " + name));
                    continue;
                }
                resourcePropertyValues.put(new QName("http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider", name), rp.toSOAPElements());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("Failed to retrieve the value of RP " + name), (Throwable)e);
            }
        }
        logger.trace((Object)"Resource Property values successfully read");
        return resourcePropertyValues;
    }

    int getPollingInterval() {
        return this.pollingInterval;
    }

    String getSource() throws Exception {
        return this.resource.getEPR().getAddress().toString();
    }

    String getName() {
        return this.resource.getClass().getSimpleName() + "(" + this.resource.getID() + ")";
    }

    Document query() throws Exception {
        logger.trace((Object)("Querying RPs for " + this.getName()));
        int attempts = 0;
        Exception ret = null;
        while (attempts++ < 3) {
            try {
                Map<QName, SOAPElement[]> values = this.getResourcePropertyValues();
                if (values == null) {
                    logger.warn((Object)"No RPs' values available at registration time");
                    continue;
                }
                StringBuilder rpd = new StringBuilder();
                rpd.append("<ResourceProperties>");
                ArrayList<MessageElement> elements = new ArrayList<MessageElement>();
                for (QName name : values.keySet()) {
                    if (name == null) continue;
                    if (values.get(name) == null) {
                        logger.trace((Object)("Skipping null values for RP " + name));
                        continue;
                    }
                    for (SOAPElement elem : values.get(name)) {
                        if (elem == null) {
                            logger.warn((Object)("Skipping null value for " + name));
                            continue;
                        }
                        elements.add((MessageElement)elem);
                    }
                }
                rpd.append(AnyHelper.toSingleString((MessageElement[])elements.toArray(new MessageElement[elements.size()])));
                rpd.append("</ResourceProperties>");
                logger.trace((Object)("Resource property document is " + rpd));
                return this.getAsDocument(rpd.toString());
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to read the RPs", (Throwable)e);
                ret = e;
                Thread.sleep(1000L);
            }
        }
        throw ret;
    }

    private Document getAsDocument(String rpd) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringReader reader = new StringReader(rpd);
        InputSource source = new InputSource(reader);
        return builder.parse(source);
    }

    String getID() throws Exception {
        String source = this.resource.getEPR().getAddress().toString();
        String id = ((GCUBEWSResourceKey)this.resource.getID()).getValue();
        return source.replace("http://", "").replace(":", "").replace("/", "-") + "-" + id.replace("http://", "").replace(":", "").replace("/", "-");
    }

    String getSourceID() throws Exception {
        return ((GCUBEWSResourceKey)this.resource.getID()).getValue();
    }

    static String getID(GCUBEWSResource resource) throws Exception {
        String source = resource.getEPR().getAddress().toString();
        String id = ((GCUBEWSResourceKey)resource.getID()).getValue();
        return source.replace("http://", "").replace(":", "").replace("/", "-") + "-" + id.replace("http://", "").replace(":", "").replace("/", "-");
    }

    String getNamespace() throws Exception {
        return ((GCUBEWSResourceKey)this.resource.getID()).getName().getNamespaceURI();
    }

    private static class PublicationProfileParser {
        private GCUBEPublicationProfile profile;
        private List<QName> names;
        private Integer pollInterval;

        PublicationProfileParser(GCUBEPublicationProfile profile) {
            this.profile = profile;
            this.names = new ArrayList<QName>();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void parse() throws Exception {
            logger.trace((Object)("Parsing pubblication profile " + this.profile.getAbsoluteFileName()));
            BufferedReader reader = new BufferedReader(new FileReader(this.profile.getAbsoluteFileName()));
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            try {
                parser.setInput((Reader)reader);
                boolean foundRPName = false;
                boolean foundInterval = false;
                block8: while (true) {
                    switch (parser.next()) {
                        case 2: {
                            for (int i = parser.getNamespaceCount(parser.getDepth() - 1); i < parser.getNamespaceCount(parser.getDepth()); ++i) {
                                logger.trace((Object)("Found namespace " + parser.getNamespacePrefix(i) + ", uri " + parser.getNamespaceUri(i)));
                                namespaces.put(parser.getNamespacePrefix(i), parser.getNamespaceUri(i));
                                namespaces.put(parser.getNamespacePrefix(i), parser.getNamespaceUri(i));
                            }
                            if (parser.getName().equalsIgnoreCase("ResourcePropertyNames")) {
                                foundRPName = true;
                            }
                            if (!parser.getName().equalsIgnoreCase("PollIntervalMillis")) break;
                            foundInterval = true;
                            break;
                        }
                        case 4: {
                            if (foundRPName) {
                                Object[] tokens = parser.getText().split(":");
                                logger.trace((Object)("Parsing RP: " + Arrays.toString(tokens)));
                                this.names.add(new QName(parser.getNamespace((String)tokens[0]), (String)tokens[tokens.length - 1]));
                                foundRPName = false;
                            }
                            if (!foundInterval) break;
                            this.pollInterval = Integer.valueOf(parser.getText());
                            foundInterval = false;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 1: {
                            break block8;
                        }
                    }
                }
                reader.close();
                return;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not configure resource publication because " + e.getMessage()));
                throw e;
            }
        }

        List<QName> getRPNames() {
            return this.names;
        }

        int getPollingInterval() {
            return this.pollInterval;
        }
    }
}

