/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.context.ISPublisherContext;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.ISPublisherHandler;

public final class RegistrationPoolExecutor {
    private static GCUBELog logger = new GCUBELog(RegistrationPoolExecutor.class);
    private static RegistrationPoolExecutor executor = null;
    private ExecutorService pool;

    private RegistrationPoolExecutor() {
        logger.debug((Object)"Initializing the ISPublisher pool...");
        try {
            int n = (Integer)ISPublisherContext.getContext().getProperty("MAX_PARALLEL_REGISTRATIONS");
            this.pool = new ThreadPoolExecutor(0, n, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            logger.debug((Object)("ISPublisher pool has been activated with a maximum capacity of " + n + " threads"));
        }
        catch (Exception exception) {
            this.pool = Executors.newCachedThreadPool();
        }
    }

    protected static RegistrationPoolExecutor getExecutor() {
        if (executor == null) {
            executor = new RegistrationPoolExecutor();
        }
        return executor;
    }

    protected synchronized Future<?> submit(ISPublisherHandler iSPublisherHandler) {
        logger.debug((Object)("New handler " + iSPublisherHandler.getClass().getName() + " submitted for resource " + iSPublisherHandler.getResourceID()));
        return this.pool.submit(iSPublisherHandler);
    }
}

