/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.instancestates.BaseInstanceStateHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RegisterInstanceStatePullHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RegisterInstanceStatePushHandler;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RegistrationPoolExecutor;
import org.gcube.common.informationsystem.publisher.impl.instancestates.RemoveInstanceStateHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.ISPublisherHandler;

public final class InstanceStatePublisher {
    private static Map<String, ISPublisherHandler> activeRegistrationsQueue = Collections.synchronizedMap(new HashMap());
    private static final GCUBELog logger = new GCUBELog(InstanceStatePublisher.class);
    private GCUBEScope publishingScope;

    public InstanceStatePublisher(GCUBEScope gCUBEScope) throws GCUBEPublisherException {
        this.publishingScope = gCUBEScope;
    }

    public void register(GCUBEWSResource gCUBEWSResource, String ... stringArray) throws GCUBEPublisherException {
        BaseInstanceStateHandler baseInstanceStateHandler;
        String string = gCUBEWSResource.getPorttypeContext().getPublicationProfile().getMode();
        if (string.equalsIgnoreCase("pull")) {
            try {
                logger.debug((Object)("Pull mode detected for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString()));
                baseInstanceStateHandler = new RegisterInstanceStatePullHandler(gCUBEWSResource, this.publishingScope, string, stringArray);
                baseInstanceStateHandler.register();
            }
            catch (Exception exception) {
                logger.error((Object)("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString()), (Throwable)exception);
                throw new GCUBEPublisherException("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString());
            }
        } else if (string.equalsIgnoreCase("push")) {
            logger.debug((Object)("Push mode detected for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString()));
            try {
                baseInstanceStateHandler = new RegisterInstanceStatePushHandler(gCUBEWSResource, this.publishingScope, string, stringArray);
            }
            catch (Exception exception) {
                logger.error((Object)("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString()), (Throwable)exception);
                throw new GCUBEPublisherException("Unable to initialise the registration handler for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString());
            }
        } else {
            logger.debug((Object)("Invalid " + string + " mode detected for " + ((GCUBEWSResourceKey)gCUBEWSResource.getID()).toString()));
            throw new GCUBEPublisherException("Invalid publication mode " + string);
        }
        try {
            String string2 = this.makeActivationKey(gCUBEWSResource, baseInstanceStateHandler);
            if (activeRegistrationsQueue.containsKey(string2) && activeRegistrationsQueue.get(string2).getFutureTask() != null) {
                logger.warn((Object)("A previous task was already activated for resource " + baseInstanceStateHandler.getResourceID()));
            } else {
                logger.debug((Object)("Scheduling a new task for resource " + baseInstanceStateHandler.getResourceID()));
                Future<?> future = RegistrationPoolExecutor.getExecutor().submit(baseInstanceStateHandler);
                baseInstanceStateHandler.setFutureTask(future);
                activeRegistrationsQueue.put(string2, baseInstanceStateHandler);
            }
        }
        catch (Exception exception) {
            throw new GCUBEPublisherException(exception.getMessage());
        }
    }

    public void remove(GCUBEWSResource gCUBEWSResource, String ... stringArray) throws GCUBEPublisherException {
        try {
            RemoveInstanceStateHandler removeInstanceStateHandler = new RemoveInstanceStateHandler(gCUBEWSResource, this.publishingScope, stringArray);
            String string = this.makeActivationKey(gCUBEWSResource, removeInstanceStateHandler);
            ISPublisherHandler iSPublisherHandler = activeRegistrationsQueue.get(string);
            if (iSPublisherHandler.getFutureTask() != null && !iSPublisherHandler.getFutureTask().cancel(true)) {
                logger.warn((Object)("Unable to cancel the registration handler for " + iSPublisherHandler.getResourceID()));
            }
            activeRegistrationsQueue.remove(string);
            removeInstanceStateHandler.execute();
        }
        catch (Exception exception) {
            logger.warn((Object)("could not complete the unregistration of " + gCUBEWSResource.getClass().getSimpleName() + "(" + gCUBEWSResource.getID() + ")"), (Throwable)exception);
            throw new GCUBEPublisherException("could not complete the unregistration of " + gCUBEWSResource.getClass().getSimpleName() + "(" + gCUBEWSResource.getID() + ")", exception);
        }
    }

    private String makeActivationKey(GCUBEWSResource gCUBEWSResource, ISPublisherHandler iSPublisherHandler) throws Exception {
        return gCUBEWSResource.getEPR().getAddress().toString() + iSPublisherHandler.getResourceID() + this.publishingScope;
    }
}

