/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.informationsystem.publisher.ISGenericPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.informationsystem.publisher.ISResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.generic.CollectorClient;
import org.gcube.common.informationsystem.publisher.impl.generic.SinkLoader;
import org.w3c.dom.Document;

public class GCUBEGenericPublisher
implements ISGenericPublisher {
    protected static final GCUBELog logger = new GCUBELog(ISGenericPublisher.class);
    private static Map<GCUBEScope, Set<EndpointReferenceType>> rpdSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private static Map<GCUBEScope, Set<EndpointReferenceType>> profileSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private static Map<GCUBEScope, Set<EndpointReferenceType>> daixSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();

    public void register(ISResource iSResource, GCUBEScope gCUBEScope, Document document) throws ISPublisherException {
        ArrayList<ISResource> arrayList = new ArrayList<ISResource>();
        arrayList.add(iSResource);
        ArrayList<Document> arrayList2 = new ArrayList<Document>();
        arrayList2.add(document);
        this.register(arrayList, iSResource.getCollection(), arrayList2, gCUBEScope);
    }

    public void register(ISResource iSResource, GCUBEScope gCUBEScope) throws ISPublisherException {
        this.register(iSResource, gCUBEScope, null);
    }

    public void register(List<ISResource> list, GCUBEScope gCUBEScope) throws ISPublisherException {
        HashMap hashMap = new HashMap();
        for (Object object : list) {
            if (!hashMap.containsKey(object.getCollection())) {
                hashMap.put(object.getCollection(), new ArrayList());
            }
            ((List)hashMap.get(object.getCollection())).add(object);
        }
        for (Object object : hashMap.keySet()) {
            this.register((List)hashMap.get(object), (String)object, null, gCUBEScope);
        }
    }

    public void remove(ISResource iSResource, GCUBEScope gCUBEScope) throws ISPublisherException {
        ArrayList<ISResource> arrayList = new ArrayList<ISResource>();
        arrayList.add(iSResource);
        this.remove(arrayList, iSResource.getCollection(), gCUBEScope);
    }

    public void update(ISResource iSResource, GCUBEScope gCUBEScope) throws ISPublisherException {
        this.register(iSResource, gCUBEScope);
    }

    public void update(List<ISResource> list, GCUBEScope gCUBEScope) throws ISPublisherException {
        this.register(list, gCUBEScope);
    }

    public void remove(List<ISResource> list, GCUBEScope gCUBEScope) throws ISPublisherException {
        HashMap hashMap = new HashMap();
        for (Object object : list) {
            if (!hashMap.containsKey(object.getCollection())) {
                hashMap.put(object.getCollection(), new ArrayList());
            }
            ((List)hashMap.get(object.getCollection())).add(object);
        }
        for (Object object : hashMap.keySet()) {
            this.remove((List)hashMap.get(object), (String)object, gCUBEScope);
        }
    }

    private Set<EndpointReferenceType> getSinks(ISResource.ISRESOURCETYPE iSRESOURCETYPE, GCUBEScope gCUBEScope) throws ISPublisherException {
        switch (iSRESOURCETYPE) {
            case PROFILE: {
                if (!profileSinks.containsKey(gCUBEScope)) {
                    profileSinks.put(gCUBEScope, SinkLoader.loadResourceSinks(gCUBEScope));
                }
                return profileSinks.get(gCUBEScope);
            }
            case RPD: {
                if (!rpdSinks.containsKey(gCUBEScope)) {
                    rpdSinks.put(gCUBEScope, SinkLoader.loadStateSinks(gCUBEScope));
                }
                return rpdSinks.get(gCUBEScope);
            }
            case WSDAIX: {
                if (!daixSinks.containsKey(gCUBEScope)) {
                    daixSinks.put(gCUBEScope, SinkLoader.loadWSDAIXSinks(gCUBEScope));
                }
                return daixSinks.get(gCUBEScope);
            }
        }
        throw new GCUBEPublisherException("Unable to find any IC instance to publish");
    }

    private void register(List<ISResource> list, String string, List<Document> list2, GCUBEScope gCUBEScope) throws ISPublisherException {
        Set<EndpointReferenceType> set = this.getSinks(list.get(0).getType(), gCUBEScope);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).getID();
        }
        Document[] documentArray = new Document[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            documentArray[i] = list.get(i).getDocument();
        }
        for (EndpointReferenceType endpointReferenceType : set) {
            int n = 0;
            boolean bl = false;
            while (n++ < 3 && !bl) {
                try {
                    CollectorClient.addDocuments(endpointReferenceType, gCUBEScope, new URI("gcube://unused"), new URI("gcube://" + string), stringArray, documentArray, list2.toArray(new Document[list2.size()]));
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    logger.error((Object)("Failed to send the Resource to the IC instance in scope " + gCUBEScope), (Throwable)exception);
                }
            }
            if (bl) continue;
            throw new GCUBEPublisherException("Failed to send the Resource to the IC instance in scope " + gCUBEScope);
        }
    }

    private void remove(List<ISResource> list, String string, GCUBEScope gCUBEScope) throws ISPublisherException {
        Set<EndpointReferenceType> set = this.getSinks(list.get(0).getType(), gCUBEScope);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).getID();
        }
        for (EndpointReferenceType endpointReferenceType : set) {
            int n = 0;
            boolean bl = false;
            while (n++ < 3 && !bl) {
                try {
                    CollectorClient.removeDocuments(endpointReferenceType, gCUBEScope, new URI("gcube://unused"), new URI("gcube://" + string), stringArray);
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    logger.error((Object)("Failed to remove the Resource from the IC instance in scope " + gCUBEScope), (Throwable)exception);
                }
            }
            if (bl) continue;
            throw new GCUBEPublisherException("Failed to remove the Resources from the IC instance in scope " + gCUBEScope);
        }
    }
}

