/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.stubs.testsuite;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.informationsystem.collector.stubs.XQueryAccessPortType;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteRequest;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteResponse;
import org.gcube.informationsystem.collector.stubs.XQueryFaultType;
import org.gcube.informationsystem.collector.stubs.service.XQueryAccessServiceLocator;

public class XQueryExecuteTester {
    private static GCUBEClientLog logger = new GCUBEClientLog(XQueryExecuteTester.class, new Properties[0]);

    public static void main(String[] args) {
        if (args.length != 4) {
            logger.fatal((Object)"Usage: XQueryExecuteTester <host> <port> <Scope> <XQueryExpressionFile>");
            return;
        }
        String portTypeURI = "http://" + args[0] + ":" + args[1] + "/wsrf/services/gcube/informationsystem/collector/XQueryAccess";
        XQueryAccessPortType port = null;
        try {
            port = new XQueryAccessServiceLocator().getXQueryAccessPortTypePort(new URL(portTypeURI));
            port = (XQueryAccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)port, (GCUBEScope)GCUBEScope.getScope((String)args[2]), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        XQueryExecuteRequest request = new XQueryExecuteRequest();
        request.setXQueryExpression(XQueryExecuteTester.readQuery(args[3]));
        try {
            logger.info((Object)("Submitting query in scope " + GCUBEScope.getScope((String)args[2]).getName() + "...."));
            XQueryExecuteResponse response = port.XQueryExecute(request);
            logger.info((Object)("Number of returned records: " + response.getSize()));
            logger.info((Object)("Dataset: \n" + response.getDataset()));
            Pattern p = Pattern.compile("<Record>(.*?)</Record>", 32);
            Matcher m = p.matcher(response.getDataset());
            while (m.find()) {
                logger.debug((Object)m.group(1));
            }
        }
        catch (XQueryFaultType e) {
            logger.error((Object)"XQuery Fault Error received", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error((Object)e);
        }
    }

    private static String readQuery(String filename) {
        String queryString = null;
        try {
            String line;
            BufferedReader input = new BufferedReader(new FileReader(filename));
            StringBuilder contents = new StringBuilder();
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            input.close();
            queryString = contents.toString();
        }
        catch (FileNotFoundException e1) {
            logger.fatal((Object)("invalid file: " + filename));
        }
        catch (IOException e) {
            logger.fatal((Object)("an error occurred when reading " + filename));
        }
        return queryString;
    }
}

