/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.stubs.testsuite;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.informationsystem.collector.stubs.XQueryAccessPortType;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteRequest;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteResponse;
import org.gcube.informationsystem.collector.stubs.XQueryFaultType;
import org.gcube.informationsystem.collector.stubs.service.XQueryAccessServiceLocator;

public class ParallelXQueryExecuteTester {
    private static GCUBEClientLog logger = new GCUBEClientLog(ParallelXQueryExecuteTester.class, new Properties[0]);

    public static void main(String[] args) {
        if (args.length != 5) {
            logger.fatal((Object)"Usage: XQueryExecuteTester <host> <port> <Scope> <XQueryExpressionFile> <parallelism>");
            return;
        }
        String portTypeURI = "http://" + args[0] + ":" + args[1] + "/wsrf/services/gcube/informationsystem/collector/XQueryAccess";
        XQueryAccessPortType tempPort = null;
        try {
            tempPort = new XQueryAccessServiceLocator().getXQueryAccessPortTypePort(new URL(portTypeURI));
            tempPort = (XQueryAccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)tempPort, (GCUBEScope)GCUBEScope.getScope((String)args[2]), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        final XQueryAccessPortType port = tempPort;
        final String queryFile = args[3];
        final String scopeName = args[2];
        for (int i = 1; i <= Integer.valueOf(args[4]); ++i) {
            new Thread(){

                @Override
                public void run() {
                    XQueryExecuteRequest request = new XQueryExecuteRequest();
                    request.setXQueryExpression(ParallelXQueryExecuteTester.readQuery(queryFile));
                    try {
                        logger.info((Object)(this.getId() + ": Submitting query in scope " + GCUBEScope.getScope((String)scopeName).getName() + "...."));
                        XQueryExecuteResponse response = port.XQueryExecute(request);
                        logger.info((Object)(this.getId() + ": Number of returned records: " + response.getSize()));
                        logger.info((Object)(this.getId() + ": Received dataset: \n" + response.getDataset()));
                        Pattern p = Pattern.compile("<Record>(.*?)</Record>", 32);
                        Matcher m = p.matcher(response.getDataset());
                        while (m.find()) {
                            logger.debug((Object)m.group(1));
                        }
                    }
                    catch (XQueryFaultType e) {
                        logger.error((Object)"XQuery Fault Error received", (Throwable)e);
                    }
                    catch (RemoteException e) {
                        logger.error((Object)e);
                    }
                }
            }.start();
        }
    }

    private static String readQuery(String filename) {
        String queryString = null;
        try {
            String line;
            BufferedReader input = new BufferedReader(new FileReader(filename));
            StringBuilder contents = new StringBuilder();
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            input.close();
            queryString = contents.toString();
        }
        catch (FileNotFoundException e1) {
            logger.fatal((Object)("invalid file: " + filename));
        }
        catch (IOException e) {
            logger.fatal((Object)("an error occurred when reading " + filename));
        }
        return queryString;
    }
}

