/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.stubs.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class MetadataRecord {
    static GCUBELog logger = new GCUBELog(MetadataRecord.class);
    private Calendar terminationTime;
    private Integer time;
    private String source;
    private String key;
    private String groupKey;
    private String entryKey;
    private TYPE type;
    private String publicationMode = "";
    private String namespace = "";

    protected MetadataRecord() {
    }

    public Calendar getGetTerminationTime() {
        return this.terminationTime;
    }

    public void setTimeToLive(Integer time) {
        this.terminationTime = new GregorianCalendar();
        this.terminationTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.terminationTime.add(13, time);
        this.time = time;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public Integer getTimeToLive() {
        return this.time;
    }

    public Document getAsDocument() throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        return factory.newDocumentBuilder().parse(new ByteArrayInputStream(this.getAsBuilder().toString().getBytes("UTF-8")));
    }

    public String toString() {
        return this.getAsBuilder().toString();
    }

    private StringBuilder getAsBuilder() {
        StringBuilder builder = new StringBuilder();
        builder.append("<Metadata>");
        builder.append("<Type>").append(this.getType().toString()).append("</Type>");
        builder.append("<Source>").append(this.getSource()).append("</Source>");
        builder.append("<TimeToLive>").append(this.getTimeToLive()).append("</TimeToLive>");
        builder.append("<GroupKey>").append(this.getGroupKey()).append("</GroupKey>");
        builder.append("<EntryKey>").append(this.getEntryKey()).append("</EntryKey>");
        builder.append("<Namespace>").append(this.getNamespace()).append("</Namespace>");
        builder.append("<Key>").append(this.getKey()).append("</Key>");
        builder.append("<PublicationMode>").append(this.getPublicationMode()).append("</PublicationMode>");
        builder.append("</Metadata>");
        return builder;
    }

    private Object getNamespace() {
        return this.namespace;
    }

    public String getPublicationMode() {
        return this.publicationMode;
    }

    public void setPublicationMode(String publicationMode) {
        this.publicationMode = publicationMode;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static enum TYPE {
        INSTANCESTATE("InstanceState"),
        GCUBERESOURCE("Profile");

        String name;

        private TYPE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

