/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist.sweep;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.resources.GCUBEInstanceStateResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEXMLResource;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XMLStorage;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.sweep.ResourceFilter;

public class Sweeper
implements Runnable {
    private static long DELAY = 180000L;
    private static long resourceExpirationTime = 1800000L;
    private static GCUBELog logger = new GCUBELog(Sweeper.class);

    public Sweeper(long delay, long resourceExpirationTime) throws Exception {
        DELAY = delay;
        Sweeper.resourceExpirationTime = resourceExpirationTime;
        logger.info((Object)("Starting sweeper thread with an interval of " + DELAY + " ms"));
    }

    @Override
    public void run() {
        if (DELAY == -1L) {
            return;
        }
        logger.info((Object)"Starting IC sweeper...");
        this.cleanDeletedResourcesList();
        this.cleanExpiredResources();
    }

    public void cleanExpiredResources() {
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            String[] ids;
            GCUBEInstanceStateResource fakeresource = new GCUBEInstanceStateResource();
            for (String id : ids = State.getDataManager().listAllCollectionResourceIDs(fakeresource.getCollectionName())) {
                try {
                    GCUBEInstanceStateResource tempresource = new GCUBEInstanceStateResource();
                    tempresource.setResourceName(id);
                    GCUBEXMLResource xmlresource = new GCUBEXMLResource(tempresource);
                    State.getDataManager().retrieveResourceContent(xmlresource);
                    logger.trace((Object)("Checking resource " + id));
                    if (!ResourceFilter.isExpired(xmlresource)) continue;
                    State.getDataManager().deleteResource(xmlresource);
                    logger.info((Object)("Resource " + xmlresource.getResourceName() + " deleted"));
                }
                catch (Exception e) {
                    logger.debug((Object)("IC sweeper - the resource " + id + " is no longer available in the storage"));
                }
            }
        }
        catch (Exception e2) {
            logger.warn((Object)"IC sweeper - an exception was rised when trying to cleanup the storage ", (Throwable)e2);
        }
    }

    public static void cleanRPs() throws XMLStorage.XMLStorageNotAvailableException {
        State.getDataManager().deleteCollection(new GCUBEInstanceStateResource().getCollectionName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDeletedResourcesList() {
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).setTimeZone(TimeZone.getTimeZone("GMT"));
        ArrayList<GCUBEXMLResource> toRemove = new ArrayList<GCUBEXMLResource>();
        for (GCUBEXMLResource res : State.deletedResources) {
            try {
                if (now.getTimeInMillis() - res.getLastUpdateTimeinMills() <= resourceExpirationTime) continue;
                toRemove.add(res);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to clean up the resources", (Throwable)e);
            }
        }
        List<GCUBEXMLResource> list = State.deletedResources;
        synchronized (list) {
            for (GCUBEXMLResource res : toRemove) {
                State.deletedResources.remove(res);
            }
        }
    }

    public long getIntervalInMS() {
        return DELAY;
    }
}

