/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist.sweep;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.resources.GCUBEXMLResource;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XQuery;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

class ResourceFilter {
    protected static GCUBELog logger = new GCUBELog(ResourceFilter.class);

    ResourceFilter() {
    }

    static boolean isExpired(GCUBEXMLResource resource) {
        if (resource.getPublicationMode().compareToIgnoreCase("pull") == 0) {
            return ResourceFilter.isPullExpired(resource);
        }
        if (resource.getPublicationMode().compareToIgnoreCase("push") == 0) {
            // empty if block
        }
        return false;
    }

    static boolean isPullExpired(GCUBEXMLResource resource) {
        logger.trace((Object)"Checking pull resource...");
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).setTimeZone(TimeZone.getTimeZone("GMT"));
        logger.trace((Object)("Now is " + now.getTimeInMillis()));
        logger.trace((Object)("Resource expires at " + resource.getTerminationTime().getTimeInMillis()));
        return now.getTimeInMillis() > resource.getTerminationTime().getTimeInMillis();
    }

    private static String readInputStreamAsString(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString();
    }

    private static String getRIStatus(String id) throws Exception {
        InputStream statusquery = ResourceFilter.class.getResourceAsStream("XQuery-RIStatus.xml");
        XQuery q = new XQuery(ResourceFilter.readInputStreamAsString(statusquery).replace("$1", id));
        ResourceSet result = State.getQueryManager().executeXQuery(q);
        XMLResource xmlres = (XMLResource)result.getResource(0L);
        return ((String)xmlres.getContent()).trim();
    }
}

