/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.exist.xmldb.XQueryService;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.ResourceSet;

public class XQuery {
    private String query_string = null;
    private static GCUBELog logger = new GCUBELog((Object)XQuery.class.getName());

    public XQuery(String xquery) {
        this.query_string = xquery;
    }

    public XQuery(FileReader file) throws IOException {
        try {
            this.query_string = this.readFile(file);
        }
        catch (IOException ioe) {
            logger.error((Object)"Unable to read the XQuery file");
            throw new IOException("Unable to read the XQuery file " + ioe.getStackTrace()[0].toString());
        }
    }

    public String toString() {
        return this.query_string;
    }

    public ResourceSet execute(Collection col) throws Exception {
        logger.info((Object)("Executing query on collection " + col.getName()));
        XQueryService service = (XQueryService)col.getService("XQueryService", "1.0");
        service.setProperty("indent", "yes");
        service.setProperty("encoding", "UTF-8");
        CompiledExpression compiled = service.compile(this.query_string);
        long start = System.currentTimeMillis();
        ResourceSet result = service.execute(compiled);
        long qtime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        logger.trace((Object)("hits:          " + result.getSize()));
        logger.trace((Object)("query time:    " + qtime + "ms"));
        return result;
    }

    protected String readFile(FileReader file) throws IOException {
        String line;
        BufferedReader f = new BufferedReader(file);
        StringBuffer xml = new StringBuffer();
        while ((line = f.readLine()) != null) {
            xml.append(line + " ");
        }
        f.close();
        return xml.toString();
    }
}

