/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XMLStorage;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XQuery;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class QueryManager
extends XMLStorage {
    private static final GCUBELog logger = new GCUBELog(QueryManager.class);
    private final int MAXQUERYATTEMPTS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceSet executeXQuery(XQuery query) throws XMLStorage.XMLStorageNotAvailableException {
        if (this.getStatus() != XMLStorage.STATUS.INITIALISED) {
            throw new XMLStorage.XMLStorageNotAvailableException("XMLStorage is not available");
        }
        boolean retry = true;
        int attempts = 0;
        ResourceSet result = null;
        Collection currentCollection = null;
        State.getDataManager().lock();
        try {
            currentCollection = this.loadAllCollections();
            while (retry && attempts < 3) {
                try {
                    result = currentCollection == null ? query.execute(this.rootCollection) : query.execute(currentCollection);
                    retry = false;
                }
                catch (XMLDBException edb) {
                    logger.error((Object)("Failed to execute XQuery " + query.toString()));
                    logger.error((Object)("Error details: " + edb.errorCode + " " + edb.getMessage()), (Throwable)edb);
                    if (edb.getCause() instanceof NullPointerException) {
                        retry = true;
                        ++attempts;
                        logger.warn((Object)"Trying a new attempt for query execution");
                        continue;
                    }
                    retry = false;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    if (e instanceof NullPointerException) {
                        retry = true;
                        ++attempts;
                        logger.warn((Object)"Trying a new attempt for query execution");
                        continue;
                    }
                    retry = false;
                }
            }
            this.resetCollection(currentCollection);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to execute the XQuery", (Throwable)e);
        }
        finally {
            State.getDataManager().unlock();
        }
        return result;
    }
}

