/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist;

import java.io.IOException;
import java.util.Properties;
import org.exist.backup.Restore;
import org.exist.security.SecurityManager;
import org.exist.storage.BrokerPool;
import org.exist.storage.ConsistencyCheckTask;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.contexts.ICServiceContext;
import org.gcube.informationsystem.collector.impl.resources.GCUBEInstanceStateResource;
import org.gcube.informationsystem.collector.impl.xmlstorage.backup.BackupsRootFolder;
import org.gcube.informationsystem.collector.impl.xmlstorage.backup.Scheduler;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.ExistBackupFolder;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.ExistScheduler;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XMLStorage;

public class DataManager
extends XMLStorage {
    private static final GCUBELog logger = new GCUBELog(DataManager.class);
    private static ExistScheduler scheduler = null;

    public synchronized void backup() throws IOException, Exception {
        logger.info((Object)"Backup requested");
        ConsistencyCheckTask check = new ConsistencyCheckTask();
        Properties props = new Properties();
        props.setProperty("output", BackupsRootFolder.createBackupFolder().getAbsolutePath());
        props.setProperty("backup", "yes");
        props.setProperty("incremental", "no");
        check.configure(null, props);
        check.execute(BrokerPool.getInstance().get(SecurityManager.SYSTEM_USER));
        logger.info((Object)"Backup completed");
        BackupsRootFolder.manageOldBackups(ExistBackupFolder.getBackupFolderFilter());
    }

    public synchronized void restore() throws IOException {
        logger.info((Object)"Restore requested");
        try {
            ExistBackupFolder lastBackup = this.getLastBackup();
            logger.info((Object)("Restoring from " + lastBackup.getBackupFile()));
            Restore restore = new Restore(USER, PWD, PWD, lastBackup.getBackupFile(), URI);
            restore.restore(false, null);
            if (Boolean.valueOf((String)ICServiceContext.getContext().getProperty("deleteRPsOnStartup", new boolean[]{true})).booleanValue()) {
                logger.info((Object)"deleting all RPs...");
                this.deleteCollection(new GCUBEInstanceStateResource().getCollectionName());
            }
            logger.info((Object)"Restore completed");
        }
        catch (Exception e1) {
            logger.fatal((Object)"Failed to restore", (Throwable)e1);
        }
    }

    private ExistBackupFolder getLastBackup() throws IOException {
        return BackupsRootFolder.getLastBackup(ExistBackupFolder.class, ExistBackupFolder.getBackupFolderFilter());
    }

    public static Scheduler getScheduler() {
        if (scheduler != null) {
            return scheduler;
        }
        String interval = (String)ICServiceContext.getContext().getProperty("scheduledBackupInHours", new boolean[]{false});
        if (interval == null) {
            return null;
        }
        scheduler = new ExistScheduler(Integer.valueOf(interval));
        return scheduler;
    }
}

