/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.resources;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.resources.DAIXResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BaseDAIXResource
implements DAIXResource {
    protected String resourceName;
    protected URI resourceURI;
    protected String collectionName;
    protected Document data = null;
    protected String dataAsString = null;
    protected final String rootElement = "Data";
    protected static GCUBELog logger = new GCUBELog(BaseDAIXResource.class);

    public BaseDAIXResource() {
    }

    public BaseDAIXResource(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public URI getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(URI resourceURI) {
        this.resourceURI = resourceURI;
    }

    @Override
    public String getCollectionName() throws DAIXResource.MalformedResourceException {
        return this.collectionName;
    }

    @Override
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Override
    public Document getContent() throws DAIXResource.MalformedResourceException {
        if (this.data != null) {
            return this.data;
        }
        if (this.dataAsString.compareToIgnoreCase("") != 0) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringReader reader = new StringReader(this.dataAsString);
                InputSource source = new InputSource(reader);
                return builder.parse(source);
            }
            catch (Exception e) {
                throw new DAIXResource.MalformedResourceException(e);
            }
        }
        throw new DAIXResource.MalformedResourceException("content is null");
    }

    @Override
    public void setContent(Document content) throws DAIXResource.MalformedResourceException {
        this.data = content;
    }

    @Override
    public void setContent(String content) throws DAIXResource.MalformedResourceException {
        this.dataAsString = content;
    }

    @Override
    public String toString() {
        if (this.dataAsString != null) {
            return this.dataAsString;
        }
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(this.data), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)"Unable to deserialise content data", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error((Object)"Unable to deserialise content data", (Throwable)e);
        }
        return "invalid resource";
    }

    @Override
    public String toStringFromElement(String elementName) throws DAIXResource.MalformedResourceException {
        Document doc;
        try {
            doc = this.getContent();
        }
        catch (Exception e) {
            return this.toString();
        }
        try {
            NodeList nodelist = doc.getElementsByTagName(elementName);
            if (nodelist == null || nodelist.getLength() == 0) {
                return this.toString();
            }
            Node targetNode = nodelist.item(0);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringBuilder ret = new StringBuilder();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            int index = 0;
            Node node = targetNode.getChildNodes().item(index);
            while (node != null) {
                StringWriter buffer = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(buffer));
                ret.append(buffer.toString().trim());
                node = targetNode.getChildNodes().item(++index);
            }
            return ret.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to deserialise content data", (Throwable)e);
            throw new DAIXResource.MalformedResourceException("Unable to deserialise the resource");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        BaseDAIXResource other = (BaseDAIXResource)obj;
        return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
    }

    @Override
    public void deserializeFromIndexing(String content) throws DAIXResource.MalformedResourceException {
        this.setContent(content);
    }

    @Override
    public String serializeForIndexing() {
        return this.toString();
    }
}

