/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.porttypes.wsdaix;

import java.rmi.RemoteException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.contexts.ICServiceContext;
import org.gcube.informationsystem.collector.impl.resources.BaseDAIXResource;
import org.gcube.informationsystem.collector.impl.resources.DAIXResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEInstanceStateResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEProfileResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEXMLResource;
import org.gcube.informationsystem.collector.impl.utils.MetadataReader;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XMLStorage;
import org.gcube.informationsystem.collector.stubs.wsdai.DataResourceUnavailableFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.GetDataResourcePropertyDocumentRequest;
import org.gcube.informationsystem.collector.stubs.wsdai.InvalidResourceNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.NotAuthorizedFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.ServiceBusyFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentResponseWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentResponseWrapperResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddSchemaRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.AddSchemaResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.CollectionAlreadyExistsFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.CreateSubcollectionRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.CreateSubcollectionResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentResponseWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentResponseWrapperResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetSchemaRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetSchemaResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.InvalidCollectionNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentResponseWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentResponseWrapperResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveSchemaRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveSchemaResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveSubcollectionRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.RemoveSubcollectionResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.SchemaAdditionMakesDocumentsInvalidFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.SchemaAlreadyExistsFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.SchemaDoesNotExistFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.SchemaInvalidFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.SchemaRemovalMakesDocumentsInvalidFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.SchemaRemovalMakesSchemaInvalidFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLCollectionPropertyDocumentType;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLWrapperType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmldb.api.base.XMLDBException;

public class XMLCollectionAccess
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(XMLCollectionAccess.class);

    public GetDocumentsResponse getDocuments(GetDocumentsRequest getDocumentsRequest) throws RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType {
        int size = getDocumentsRequest.getGetDocumentRequestWrapper().length;
        String targetCollection = this.URItoCollection(getDocumentsRequest.getCollectionName());
        GetDocumentResponseWrapper[] responseWrapper = new GetDocumentResponseWrapper[size];
        for (int i = 0; i < size; ++i) {
            String resourceName = getDocumentsRequest.getGetDocumentRequestWrapper(i).getDocumentName();
            responseWrapper[i] = new GetDocumentResponseWrapper();
            responseWrapper[i].setDocumentName(resourceName);
            try {
                BaseDAIXResource resource;
                if (targetCollection.startsWith(GCUBEProfileResource.ROOT_COLLECTION_NAME)) {
                    resource = new GCUBEProfileResource();
                    ((GCUBEProfileResource)resource).setResourceType(targetCollection.split("/")[2]);
                } else {
                    resource = targetCollection.startsWith("Properties") ? new GCUBEInstanceStateResource() : new BaseDAIXResource();
                }
                resource.setCollectionName(targetCollection);
                resource.setResourceName(resourceName);
                GCUBEXMLResource xmlResource = new GCUBEXMLResource(resource);
                logger.trace((Object)("Retrieving resource " + resourceName + " from collection " + xmlResource.getCollectionName()));
                State.getDataManager().retrieveResourceContent(xmlResource);
                XMLWrapperType wrapper = new XMLWrapperType();
                MessageElement msgElem = new MessageElement(xmlResource.getContent().getDocumentElement());
                wrapper.set_any(new MessageElement[]{msgElem});
                responseWrapper[i].setData(wrapper);
                responseWrapper[i].setResponse(GetDocumentResponseWrapperResponse.value1);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Unable to get the resource: " + e));
                responseWrapper[i].setResponse(GetDocumentResponseWrapperResponse.value2);
            }
        }
        GetDocumentsResponse response = new GetDocumentsResponse();
        response.setGetDocumentResponseWrapper(responseWrapper);
        return response;
    }

    public AddDocumentsResponse addDocuments(AddDocumentsRequest addDocumentsRequest) throws RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType {
        DocumentBuilder bd;
        AddDocumentRequestWrapper[] docs = addDocumentsRequest.getAddDocumentRequestWrapper();
        AddDocumentResponseWrapper[] responseWrappers = new AddDocumentResponseWrapper[docs.length];
        String targetCollection = this.URItoCollection(addDocumentsRequest.getCollectionName());
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        try {
            bd = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e3) {
            throw new RemoteException("Unable to create a Document Factory for the incoming documents");
        }
        logger.debug((Object)("Adding " + docs.length + " documents to collection " + targetCollection));
        for (int i = 0; i < docs.length; ++i) {
            BaseDAIXResource resource;
            String resourceName = docs[i].getDocumentName();
            responseWrappers[i] = new AddDocumentResponseWrapper();
            responseWrappers[i].setDocumentName(resourceName);
            logger.info((Object)("Storing resource " + resourceName));
            MessageElement elem = docs[i].getData().get_any()[0];
            Document doc = null;
            try {
                Document o = elem.getAsDocument();
                if (!(o instanceof Document)) {
                    throw new Exception("Unable to add resource " + resourceName + " because of a problem deserializing the document");
                }
                doc = o;
            }
            catch (Exception e) {
                logger.error((Object)"Unable to read the resource", (Throwable)e);
                responseWrappers[i].setResponse(AddDocumentResponseWrapperResponse.value2);
                continue;
            }
            MetadataReader metadataReader = null;
            try {
                metadataReader = this.getMetadata(docs[i].getData().get_any(), resourceName);
                if (metadataReader.getType().compareToIgnoreCase("Profile") == 0) {
                    resource = new GCUBEProfileResource();
                } else if (metadataReader.getType().compareToIgnoreCase("InstanceState") == 0) {
                    resource = new GCUBEInstanceStateResource();
                } else {
                    resource = new BaseDAIXResource();
                    resource.setCollectionName(targetCollection);
                }
            }
            catch (Exception e2) {
                resource = new BaseDAIXResource();
                resource.setCollectionName(targetCollection);
                metadataReader = null;
            }
            try {
                resource.setResourceName(resourceName);
                if (doc.getDocumentElement().getLocalName().equals("ISPublisher")) {
                    Document newDoc = bd.newDocument();
                    Node node = doc.getDocumentElement().removeChild(doc.getDocumentElement().getFirstChild());
                    newDoc.appendChild(newDoc.importNode(node, true));
                    resource.setContent(newDoc);
                } else {
                    resource.setContent(doc);
                }
            }
            catch (DAIXResource.MalformedResourceException e1) {
                logger.error((Object)"Invalid resource ", (Throwable)e1);
                responseWrappers[i].setResponse(AddDocumentResponseWrapperResponse.value2);
                continue;
            }
            try {
                GCUBEXMLResource xmlResource = this.wrap(resource, metadataReader);
                boolean exist = false;
                if (State.getDataManager().resourceExists(xmlResource)) {
                    exist = true;
                }
                State.getDataManager().storeResource(xmlResource);
                logger.info((Object)("Resource " + resource.getResourceName() + " successfully stored"));
                if (exist) {
                    responseWrappers[i].setResponse(AddDocumentResponseWrapperResponse.value5);
                    continue;
                }
                responseWrappers[i].setResponse(AddDocumentResponseWrapperResponse.value1);
                continue;
            }
            catch (GCUBEXMLResource.MalformedXMLResourceException e) {
                logger.error((Object)"Invalid resource ", (Throwable)e);
                responseWrappers[i].setResponse(AddDocumentResponseWrapperResponse.value2);
                continue;
            }
            catch (XMLStorage.XMLStorageNotAvailableException e) {
                logger.error((Object)"Storage not available ", (Throwable)e);
                responseWrappers[i].setResponse(AddDocumentResponseWrapperResponse.value4);
            }
        }
        AddDocumentsResponse r = new AddDocumentsResponse();
        r.setAddDocumentResponseWrapper(responseWrappers);
        return r;
    }

    private MetadataReader getMetadata(MessageElement[] elements, String resourceName) throws Exception {
        if (elements.length > 1) {
            MessageElement elem2 = elements[1];
            try {
                Document o = elem2.getAsDocument();
                if (!(o instanceof Document)) {
                    throw new Exception("Unable to add resource " + resourceName + " because of a problem deserializing the metadata");
                }
                return new MetadataReader(o);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to read resource's metadata", (Throwable)e);
                throw new Exception("Unable to read resource " + resourceName + " metadata", e);
            }
        }
        throw new Exception("Unable to find any resource's metadata record for " + resourceName);
    }

    private GCUBEXMLResource wrap(BaseDAIXResource resource, MetadataReader metadataReader) throws GCUBEXMLResource.MalformedXMLResourceException {
        GCUBEXMLResource xmlResource = new GCUBEXMLResource(resource);
        if (metadataReader != null) {
            xmlResource.setSource(metadataReader.getSource());
            xmlResource.setTerminationTime(metadataReader.getTerminationTime());
            xmlResource.setGroupKey(metadataReader.getGroupKey());
            xmlResource.setEntryKey(metadataReader.getEntryKey());
            xmlResource.setSourceKey(metadataReader.getKey());
            xmlResource.setNamespace(metadataReader.getNamespace());
            xmlResource.setPublicationMode(metadataReader.getPublicationMode());
        }
        return xmlResource;
    }

    public RemoveDocumentsResponse removeDocuments(RemoveDocumentsRequest removeDocumentsRequest) throws RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType {
        RemoveDocumentsResponse response = new RemoveDocumentsResponse();
        RemoveDocumentRequestWrapper[] docs = removeDocumentsRequest.getRemoveDocumentRequestWrapper();
        RemoveDocumentResponseWrapper[] responseWrappers = new RemoveDocumentResponseWrapper[docs.length];
        String targetCollection = this.URItoCollection(removeDocumentsRequest.getCollectionName());
        for (int i = 0; i < docs.length; ++i) {
            String resourceName = docs[i].getDocumentName();
            logger.info((Object)("Removing resource " + resourceName + " from " + targetCollection));
            responseWrappers[i] = new RemoveDocumentResponseWrapper();
            responseWrappers[i].setDocumentName(resourceName);
            try {
                BaseDAIXResource resource = new BaseDAIXResource(resourceName);
                resource.setCollectionName(targetCollection);
                GCUBEXMLResource xmlResource = new GCUBEXMLResource(resource);
                if (!State.getDataManager().resourceExists(xmlResource)) {
                    responseWrappers[i].setResponse(RemoveDocumentResponseWrapperResponse.value3);
                    continue;
                }
                State.getDataManager().deleteResource(xmlResource);
                logger.info((Object)("Resource " + xmlResource.getResourceName() + " successfully removed"));
                responseWrappers[i].setResponse(RemoveDocumentResponseWrapperResponse.value1);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Unable to remove the resource: " + e));
                responseWrappers[i].setResponse(RemoveDocumentResponseWrapperResponse.value2);
            }
        }
        response.setRemoveDocumentResponseWrapper(responseWrappers);
        return response;
    }

    public CreateSubcollectionResponse createSubcollection(CreateSubcollectionRequest createSubcollectionRequest) throws RemoteException, CollectionAlreadyExistsFaultType, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType, DataResourceUnavailableFaultType {
        String collectionPath = null;
        if (createSubcollectionRequest.getCollectionName() != null) {
            collectionPath = this.URItoCollection(createSubcollectionRequest.getCollectionName());
            if (collectionPath != null && !State.getDataManager().collectionExists(collectionPath)) {
                logger.warn((Object)"Invalid collection name");
                throw new InvalidCollectionNameFaultType();
            }
        } else {
            logger.warn((Object)("Collection " + collectionPath + " does not exist, assuming ROOT collection"));
        }
        if (createSubcollectionRequest.getSubcollectionName() == null) {
            logger.warn((Object)"Invalid subcollection name");
            throw new InvalidCollectionNameFaultType();
        }
        String subCollectionName = this.URItoCollection(createSubcollectionRequest.getSubcollectionName());
        if (collectionPath != null) {
            subCollectionName = collectionPath + "/" + subCollectionName;
        }
        if (State.getDataManager().collectionExists(subCollectionName)) {
            logger.warn((Object)("Collection " + subCollectionName + " already exists"));
            throw new CollectionAlreadyExistsFaultType();
        }
        try {
            State.getDataManager().createCollection(subCollectionName);
        }
        catch (XMLDBException e) {
            logger.error((Object)"Unable to create subcollection", (Throwable)e);
            throw new ServiceBusyFaultType();
        }
        catch (XMLStorage.XMLStorageNotAvailableException e) {
            logger.error((Object)"Unable to create subcollection", (Throwable)e);
            throw new DataResourceUnavailableFaultType();
        }
        return new CreateSubcollectionResponse();
    }

    public RemoveSubcollectionResponse removeSubcollection(RemoveSubcollectionRequest removeSubcollectionRequest) throws RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType, DataResourceUnavailableFaultType {
        if (removeSubcollectionRequest.getSubcollectionName() == null) {
            throw new InvalidCollectionNameFaultType();
        }
        String collectionPath = null;
        if (removeSubcollectionRequest.getCollectionName() != null) {
            collectionPath = this.URItoCollection(removeSubcollectionRequest.getCollectionName());
            if (collectionPath != null && !State.getDataManager().collectionExists(collectionPath)) {
                logger.warn((Object)"Invalid collection name");
                throw new InvalidCollectionNameFaultType();
            }
        } else {
            logger.warn((Object)("Collection " + collectionPath + " does not exist, assuming ROOT collection"));
        }
        String subCollectionName = this.URItoCollection(removeSubcollectionRequest.getSubcollectionName());
        if (collectionPath != null) {
            subCollectionName = collectionPath + "/" + subCollectionName;
        }
        if (!State.getDataManager().collectionExists(subCollectionName)) {
            logger.warn((Object)("Collection " + subCollectionName + " does not exist"));
            throw new InvalidCollectionNameFaultType();
        }
        try {
            State.getDataManager().deleteCollection(subCollectionName);
            logger.info((Object)("Collection " + subCollectionName + " successfully removed"));
        }
        catch (XMLStorage.XMLStorageNotAvailableException e) {
            logger.error((Object)"Unable to create subcollection", (Throwable)e);
            throw new DataResourceUnavailableFaultType();
        }
        return new RemoveSubcollectionResponse();
    }

    public AddSchemaResponse addSchema(AddSchemaRequest addSchemaRequest) throws SchemaInvalidFaultType, DataResourceUnavailableFaultType, ServiceBusyFaultType, SchemaAdditionMakesDocumentsInvalidFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, SchemaAlreadyExistsFaultType, NotAuthorizedFaultType {
        throw new NotAuthorizedFaultType();
    }

    public GetSchemaResponse getSchema(GetSchemaRequest getSchemaRequest) throws DataResourceUnavailableFaultType, ServiceBusyFaultType, SchemaDoesNotExistFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType {
        throw new NotAuthorizedFaultType();
    }

    public RemoveSchemaResponse removeSchema(RemoveSchemaRequest removeSchemaRequest) throws DataResourceUnavailableFaultType, ServiceBusyFaultType, SchemaRemovalMakesDocumentsInvalidFaultType, SchemaDoesNotExistFaultType, InvalidResourceNameFaultType, SchemaRemovalMakesSchemaInvalidFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType {
        throw new NotAuthorizedFaultType();
    }

    public XMLCollectionPropertyDocumentType getCollectionPropertyDocument(GetDataResourcePropertyDocumentRequest request) throws DataResourceUnavailableFaultType, ServiceBusyFaultType, InvalidResourceNameFaultType, NotAuthorizedFaultType {
        throw new NotAuthorizedFaultType();
    }

    private String URItoCollection(URI collection) {
        if (collection.getPath() == null || collection.getPath().length() == 0) {
            return collection.getHost();
        }
        return collection.getHost() + "/" + collection.getPath();
    }

    protected GCUBEServiceContext getServiceContext() {
        return ICServiceContext.getContext();
    }
}

