/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.porttypes;

import java.io.IOException;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.types.VOID;
import org.gcube.informationsystem.collector.impl.contexts.ICServiceContext;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.gcube.informationsystem.collector.stubs.AlreadyConnectedFaultType;
import org.gcube.informationsystem.collector.stubs.BackupFailedFaultType;
import org.gcube.informationsystem.collector.stubs.BackupNotAvailableFaultType;
import org.gcube.informationsystem.collector.stubs.ShutdownFailedFaultType;
import org.gcube.informationsystem.collector.stubs.XMLStorageNotAvailableFaultType;
import org.xmldb.api.base.XMLDBException;

public class XMLStorageAccess
extends GCUBEPortType {
    protected GCUBEServiceContext getServiceContext() {
        return ICServiceContext.getContext();
    }

    public VOID backup(VOID params) throws BackupFailedFaultType, XMLStorageNotAvailableFaultType {
        try {
            State.getDataManager().backup();
        }
        catch (XMLDBException e) {
            this.logger.error((Object)"Failed to backup", (Throwable)e);
            throw new XMLStorageNotAvailableFaultType();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to backup", (Throwable)e);
            BackupFailedFaultType fault = new BackupFailedFaultType();
            fault.addFaultDetailString("");
            throw fault;
        }
        return new VOID();
    }

    public VOID restore(VOID params) throws BackupNotAvailableFaultType, XMLStorageNotAvailableFaultType {
        try {
            State.getDataManager().restore();
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to restore the last backup", (Throwable)e);
            BackupNotAvailableFaultType fault = new BackupNotAvailableFaultType();
            fault.addFaultDetailString("No valid backup has been found");
            throw fault;
        }
        return new VOID();
    }

    public VOID shutdown(VOID params) throws BackupFailedFaultType, XMLStorageNotAvailableFaultType, ShutdownFailedFaultType {
        this.logger.info((Object)"Shutdown operation invoked");
        try {
            State.getDataManager().backup();
        }
        catch (XMLDBException e) {
            this.logger.error((Object)"Unable to backup before shutting down", (Throwable)e);
            XMLStorageNotAvailableFaultType fault = new XMLStorageNotAvailableFaultType();
            fault.addFaultDetailString("No valid backup has been found");
            throw fault;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to backup before shutting down", (Throwable)e);
            BackupFailedFaultType fault = new BackupFailedFaultType();
            fault.addFaultDetailString("No valid backup has been found");
            throw fault;
        }
        try {
            State.dispose();
        }
        catch (Exception e) {
            this.logger.error((Object)"Shutdown failed", (Throwable)e);
            ShutdownFailedFaultType fault = new ShutdownFailedFaultType();
            fault.addFaultDetailString("Shutdown failed," + e.getMessage());
            throw fault;
        }
        return new VOID();
    }

    public VOID connect(VOID params) throws XMLStorageNotAvailableFaultType, AlreadyConnectedFaultType {
        this.logger.info((Object)"Connect operation invoked");
        try {
            State.initialize();
        }
        catch (Exception e) {
            this.logger.error((Object)"Initialisation failed", (Throwable)e);
            XMLStorageNotAvailableFaultType fault = new XMLStorageNotAvailableFaultType();
            fault.addFaultDetailString("Initialisation failed," + e.getMessage());
            throw fault;
        }
        return new VOID();
    }
}

