/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exist.xmldb.DatabaseInstanceManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.resources.GCUBEXMLResource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

public class XMLStorage {
    protected static String URI = "xmldb:exist://";
    protected static String USER = "admin";
    protected static String PWD = "";
    protected static String driver = "org.exist.xmldb.DatabaseImpl";
    private static GCUBELog logger = new GCUBELog(XMLStorage.class);
    private Database database;
    protected Collection rootCollection;
    protected Lock lock;
    private Lock writeLock;
    protected Lock readLock;
    private boolean locked = false;
    private STATUS status = STATUS.CLOSED;
    protected long maxOperationsPerConnection = 1000L;
    protected long operationsCounter = 0L;

    public XMLStorage() {
        logger.debug((Object)"Creating a new XMLStorage");
        this.writeLock = this.lock = new ReentrantLock();
        this.readLock = this.lock;
    }

    public void initialize(boolean ... lock) throws XMLStorageNotAvailableException {
        this.initialize(this.maxOperationsPerConnection, lock);
    }

    public void initialize(long maxOperationsPerConnection, boolean ... lock) throws XMLStorageNotAvailableException {
        if (this.getStatus() == STATUS.INITIALISED) {
            logger.warn((Object)"XMLStorage already initialized");
            return;
        }
        if (lock != null && lock.length > 0 && lock[0]) {
            this.lock();
        }
        try {
            logger.info((Object)"Initializing XMLStorage...");
            this.maxOperationsPerConnection = maxOperationsPerConnection;
            Class<?> cl = Class.forName(driver);
            this.database = (Database)cl.newInstance();
            this.database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)this.database);
            logger.info((Object)"Initializing the root collection");
            this.rootCollection = DatabaseManager.getCollection((String)(URI + "/db"), (String)USER, (String)PWD);
            if (this.rootCollection == null) {
                logger.error((Object)"invalid root collection!");
                throw new XMLStorageNotAvailableException("unable to load root collection");
            }
            this.rootCollection.setProperty("pretty", "true");
            this.rootCollection.setProperty("encoding", "UTF-8");
            this.setStatus(STATUS.INITIALISED);
            logger.info((Object)"XMLStorage initialized with success");
        }
        catch (XMLDBException edb) {
            logger.error((Object)"unable to initialize XML storage ", (Throwable)edb);
            throw new XMLStorageNotAvailableException("unable to initialize XML storage");
        }
        catch (Exception e) {
            logger.error((Object)"unable to initialize XML storage ", (Throwable)e);
            throw new XMLStorageNotAvailableException("unable to initialize XML storage");
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.error((Object)"unable to initialize XML storage", (Throwable)ncdfe);
            throw new XMLStorageNotAvailableException("unable to initialize XML storage");
        }
        finally {
            if (lock != null && lock.length > 0 && lock[0]) {
                this.unlock();
            }
        }
    }

    public Collection createCollection(String name) throws XMLDBException, XMLStorageNotAvailableException {
        String[] subcollections = name.split("/");
        Collection parent = this.rootCollection;
        for (String subcollection : subcollections) {
            Collection child = parent.getChildCollection(subcollection);
            logger.info((Object)("Creating subcollection " + subcollection));
            if (child == null) {
                child = this.createCollection(parent, subcollection);
                if (child == null) {
                    throw new XMLStorageNotAvailableException("unable to create collection " + name);
                }
                child.setProperty("pretty", "true");
                child.setProperty("encoding", "UTF-8");
            }
            parent = child;
        }
        return parent;
    }

    protected void lock() {
        this.writeLock.lock();
        this.locked = true;
        logger.trace((Object)"WRITE LOCK acquired");
    }

    protected void unlock() {
        this.writeLock.unlock();
        this.locked = false;
        logger.trace((Object)"WRITE LOCK released");
    }

    public boolean shutdown(boolean lock) {
        if (lock) {
            this.lock();
        }
        logger.info((Object)"XML storage is shutting down");
        try {
            DatabaseInstanceManager manager = (DatabaseInstanceManager)this.rootCollection.getService("DatabaseInstanceManager", "1.0");
            manager.shutdown();
            this.setStatus(STATUS.SHUTDOWN);
            logger.info((Object)"...XML storage is down");
            if (lock) {
                this.lock();
            }
        }
        catch (XMLDBException edb) {
            logger.fatal((Object)"Unable to shutdown XML storage", (Throwable)edb);
        }
        return true;
    }

    private Collection loadCollection(String collectionName) throws XMLStorageNotAvailableException {
        return this.loadCollection(this.rootCollection, collectionName);
    }

    private Collection loadCollection(Collection parentCollection, String collectionName) throws XMLStorageNotAvailableException {
        String[] subcollections = collectionName.split("/");
        if (subcollections.length < 1) {
            logger.error((Object)("Invalid collection name " + collectionName));
            return null;
        }
        Collection currentCollection = null;
        try {
            for (String subcollection : subcollections) {
                currentCollection = parentCollection.getChildCollection(subcollection);
                if (currentCollection == null) {
                    logger.info((Object)("Creating a new collection " + collectionName + "..."));
                    currentCollection = this.createCollection(collectionName);
                }
                currentCollection.setProperty("pretty", "true");
                currentCollection.setProperty("encoding", "UTF-8");
                parentCollection = currentCollection;
            }
        }
        catch (XMLDBException edb) {
            logger.error((Object)("failed to create collection " + collectionName + "!"));
            logger.error((Object)("" + edb.getCause()));
        }
        catch (NullPointerException e) {
            logger.fatal((Object)"the XMLStorage is GONE!! a Restore is needed");
        }
        return currentCollection;
    }

    protected void resetCollection(Collection currentCollection) {
        try {
            currentCollection.close();
        }
        catch (XMLDBException edb) {
            logger.error((Object)("unable to close collection " + edb.getMessage()));
        }
        currentCollection = null;
    }

    public Collection loadAllCollections() {
        Collection currentCollection = null;
        logger.debug((Object)"Loading all collections... ");
        try {
            currentCollection = DatabaseManager.getCollection((String)(URI + "/db"), (String)USER, (String)PWD);
        }
        catch (XMLDBException edb) {
            logger.error((Object)"Failed to load all collections!");
            logger.error((Object)"", (Throwable)edb);
        }
        return currentCollection;
    }

    public void storeResource(GCUBEXMLResource resource) throws XMLStorageNotAvailableException, GCUBEXMLResource.MalformedXMLResourceException {
        this.lock();
        if (this.status != STATUS.INITIALISED) {
            this.unlock();
            throw new XMLStorageNotAvailableException("XMLStorage not initialized");
        }
        Collection currentCollection = this.loadCollection(resource.getCollectionName());
        if (currentCollection == null) {
            logger.error((Object)"Unable to open the Collection");
            this.unlock();
            throw new XMLStorageNotAvailableException("Unable to open the Collection");
        }
        try {
            XMLResource document = (XMLResource)currentCollection.createResource(resource.getResourceName(), "XMLResource");
            document.setContent((Object)resource.toString());
            logger.debug((Object)("Storing/updating resource " + document.getId() + " in collection " + currentCollection.getName() + "..."));
            logger.trace((Object)("Resource content: " + document.getContent().toString()));
            currentCollection.storeResource((Resource)document);
            logger.debug((Object)"...done");
        }
        catch (XMLDBException edb) {
            logger.error((Object)("Failed to store resource " + resource.getResourceName()));
            logger.error((Object)("" + edb.errorCode + " " + edb.getMessage()), (Throwable)edb);
            throw new GCUBEXMLResource.MalformedXMLResourceException((Exception)((Object)edb));
        }
        catch (Exception e) {
            logger.error((Object)("" + e.getMessage()), (Throwable)e);
            throw new GCUBEXMLResource.MalformedXMLResourceException(e);
        }
        finally {
            this.resetCollection(currentCollection);
            ++this.operationsCounter;
            this.unlock();
        }
        this.checkConnection();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public synchronized void retrieveResourceContent(GCUBEXMLResource resource) throws Exception {
        XMLResource res = null;
        Collection currentCollection = this.loadCollection(resource.getCollectionName());
        try {
            res = (XMLResource)currentCollection.getResource(resource.getResourceName());
            if (res == null) {
                logger.warn((Object)("Resource " + resource.getResourceName() + " not found!"));
                throw new Exception("Resource " + resource.getResourceName() + " not found!");
            }
            if (res.getContent() == null) {
                logger.warn((Object)("Resource content for " + resource.getResourceName() + " not found!"));
                throw new Exception("Resource content for " + resource.getResourceName() + " not found!");
            }
            resource.deserializeFromIndexing(res.getContent().toString(), true);
        }
        catch (XMLDBException edb) {
            logger.error((Object)("Failed to retrieve document " + resource.getResourceName()));
            logger.error((Object)("" + edb.errorCode + " " + edb.getMessage()), (Throwable)edb);
            throw new Exception("Failed to retrieve document " + resource.getResourceName());
        }
        finally {
            this.resetCollection(currentCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceExists(GCUBEXMLResource resource) throws GCUBEXMLResource.MalformedXMLResourceException, XMLStorageNotAvailableException {
        XMLResource res = null;
        Collection currentCollection = this.loadCollection(resource.getCollectionName());
        try {
            res = (XMLResource)currentCollection.getResource(resource.getResourceName());
        }
        catch (XMLDBException edb) {
            logger.warn((Object)("Resource " + resource.getResourceName() + " not found!"));
        }
        finally {
            this.resetCollection(currentCollection);
        }
        return res != null;
    }

    public synchronized GCUBEXMLResource executeXPathQuery(String xpathquery) {
        GCUBEXMLResource res = null;
        return res;
    }

    public synchronized void deleteResource(GCUBEXMLResource resource) throws Exception {
        if (resource.getResourceName() == null) {
            logger.warn((Object)"Invalid resource name");
            return;
        }
        this.lock();
        Collection collection = this.loadCollection(resource.getCollectionName());
        if (collection == null) {
            collection = this.rootCollection;
        }
        try {
            logger.info((Object)("Trying to remove resource " + resource.getResourceName() + " from collection " + collection.getName()));
            this.deleteResource(resource.getResourceName(), collection, false);
        }
        catch (XMLDBException edb) {
            logger.error((Object)"Failed to remove the resource from the storage! ");
            logger.error((Object)"", (Throwable)edb);
            throw new Exception();
        }
        finally {
            this.resetCollection(collection);
            this.unlock();
        }
    }

    private void deleteResource(String resourceID, Collection col, boolean ... lock) throws Exception {
        XMLResource res = null;
        if (lock != null && lock.length > 0 && lock[0]) {
            this.lock();
        }
        try {
            res = (XMLResource)col.getResource(resourceID);
            if (res == null) {
                logger.warn((Object)("Resource " + resourceID + " not found!"));
            } else {
                col.removeResource((Resource)res);
                logger.info((Object)"Resource successfully removed");
            }
        }
        catch (XMLDBException edb) {
            logger.error((Object)("Failed to retrieve resource " + resourceID));
            throw new Exception(edb);
        }
        finally {
            this.resetCollection(col);
            if (lock != null && lock.length > 0 && lock[0]) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printResourcesIDs() {
        Collection currentCollection = null;
        currentCollection = this.loadAllCollections();
        try {
            String[] ress = currentCollection == null ? this.rootCollection.listResources() : currentCollection.listResources();
            for (int i = 0; i < ress.length; ++i) {
                logger.debug((Object)("Resource ID:" + ress[i]));
            }
        }
        catch (XMLDBException edb) {
            logger.error((Object)"Failed to read resource IDs ", (Throwable)edb);
        }
        finally {
            this.resetCollection(currentCollection);
        }
    }

    public boolean collectionExists(String collectionName) {
        String[] subcollections = collectionName.split("/");
        Collection parent = this.rootCollection;
        for (String subcollection : subcollections) {
            try {
                Collection child = parent.getChildCollection(subcollection);
                if (child == null) {
                    return false;
                }
                parent = child;
            }
            catch (XMLDBException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection createCollection(Collection parentCollection, String collectionName) {
        Collection col = null;
        this.lock();
        try {
            CollectionManagementService mgtService = (CollectionManagementService)parentCollection.getService("CollectionManagementService", "1.0");
            col = mgtService.createCollection(collectionName);
        }
        catch (XMLDBException edb) {
            logger.error((Object)("Failed to create collection " + collectionName), (Throwable)edb);
        }
        finally {
            this.unlock();
        }
        return col;
    }

    public void deleteCollection(String collectionName) throws XMLStorageNotAvailableException {
        this.lock();
        try {
            CollectionManagementService mgtService = (CollectionManagementService)this.rootCollection.getService("CollectionManagementService", "1.0");
            mgtService.removeCollection(collectionName);
            logger.info((Object)"Collection deleted");
        }
        catch (XMLDBException edb) {
            logger.warn((Object)("Unable to delete the collection " + collectionName + ": " + edb.toString()));
            throw new XMLStorageNotAvailableException("Unable to delete the collection " + collectionName);
        }
        finally {
            this.unlock();
        }
    }

    public String[] listAllCollectionResourceIDs(String collectionName) throws XMLStorageNotAvailableException {
        return this.listAllCollectionResourceIDs(this.loadCollection(collectionName));
    }

    public STATUS getStatus() {
        logger.trace((Object)("Status is " + (Object)((Object)this.status)));
        return this.status;
    }

    public void setStatus(STATUS status) {
        logger.trace((Object)("New status is " + (Object)((Object)status)));
        this.status = status;
    }

    private String[] listAllCollectionResourceIDs(Collection collection) {
        String[] ids = null;
        String collectionName = "";
        try {
            collectionName = collection.getName();
            logger.debug((Object)("Retrieving all resource IDs from collection " + collectionName));
            ids = new String[collection.getResourceCount()];
            ids = collection.listResources();
            logger.debug((Object)("Retrieved " + ids.length + " elements"));
        }
        catch (XMLDBException edb) {
            logger.warn((Object)("Unable to retrieve ids from collection " + collectionName + " " + edb.toString()));
        }
        return ids;
    }

    protected void checkConnection() {
        if (this.operationsCounter > this.maxOperationsPerConnection) {
            logger.info((Object)"It's time to reset the connection...");
            this.lock();
            this.shutdown(false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.initialize(false);
            }
            catch (XMLStorageNotAvailableException e) {
                logger.fatal((Object)"Unable to initialize XML storage", (Throwable)e);
            }
            this.operationsCounter = 0L;
            this.unlock();
            logger.info((Object)"Connection reset");
        }
    }

    public static class XMLStorageNotAvailableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XMLStorageNotAvailableException(String message) {
            super(message);
        }
    }

    static enum STATUS {
        INITIALISED,
        CLOSED,
        SHUTDOWN;

    }
}

