/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.contexts.ICServiceContext;
import org.gcube.informationsystem.collector.impl.resources.GCUBEInstanceStateResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEXMLResource;
import org.gcube.informationsystem.collector.impl.xmlstorage.backup.Scheduler;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.DataManager;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.QueryManager;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XMLStorage;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.sweep.Sweeper;

public class State {
    private static DataManager dataManager;
    private static QueryManager queryManager;
    public static List<GCUBEXMLResource> deletedResources;
    private static GCUBELog logger;
    private static boolean isInitialized;

    public static void initialize() throws Exception {
        logger.info((Object)"Starting IC service initialization...");
        if (isInitialized) {
            logger.info((Object)"Service's state is already initialized");
            return;
        }
        long maxOperations = Long.valueOf((String)ICServiceContext.getContext().getProperty("maxOperationsPerConnection", new boolean[]{true}));
        State.initializeDataManager(maxOperations);
        State.initializeQueryManager(maxOperations);
        if (Boolean.valueOf((String)ICServiceContext.getContext().getProperty("deleteRPsOnStartup", new boolean[]{true})).booleanValue()) {
            logger.info((Object)"Deleting all RPs...");
            try {
                dataManager.deleteCollection(new GCUBEInstanceStateResource().getCollectionName());
            }
            catch (XMLStorage.XMLStorageNotAvailableException e) {
                logger.warn((Object)"Unable to delete the properties's collection");
            }
        } else {
            logger.info((Object)"All RPs previously stored are kept in the storage");
        }
        logger.info((Object)"Initialising the sweeper...");
        Sweeper sweeper = new Sweeper(Long.valueOf((String)ICServiceContext.getContext().getProperty("sweeperIntervalInMillis", new boolean[]{true})), Long.valueOf((String)ICServiceContext.getContext().getProperty("resourceExpirationTimeInMillis", new boolean[]{true})));
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(sweeper, sweeper.getIntervalInMS(), sweeper.getIntervalInMS(), TimeUnit.MILLISECONDS);
        logger.info((Object)"Initialising the scheduled backups...");
        Scheduler scheduler = DataManager.getScheduler();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(scheduler, scheduler.getIntervalInMS(), scheduler.getIntervalInMS(), TimeUnit.MILLISECONDS);
        logger.info((Object)"IC service initialization completed");
        isInitialized = true;
    }

    private static void initializeDataManager(long maxOperations) throws Exception {
        if (dataManager == null) {
            dataManager = new DataManager();
        }
        if (dataManager.getStatus() != XMLStorage.STATUS.INITIALISED) {
            dataManager.initialize(maxOperations, new boolean[0]);
        } else {
            logger.info((Object)"DataManager already initalized");
        }
    }

    private static void initializeQueryManager(long maxOperations) throws Exception {
        if (queryManager == null) {
            queryManager = new QueryManager();
        }
        if (queryManager.getStatus() != XMLStorage.STATUS.INITIALISED) {
            queryManager.initialize(maxOperations, new boolean[0]);
        } else {
            logger.info((Object)"QueryManager already initalized");
        }
    }

    public static void dispose() throws Exception {
        logger.info((Object)"Disposing IC service's resources...");
        if (!isInitialized) {
            logger.info((Object)"Service's state is already disposed");
            return;
        }
        dataManager.shutdown(true);
        queryManager.shutdown(true);
        isInitialized = false;
    }

    public static DataManager getDataManager() {
        return dataManager;
    }

    public static QueryManager getQueryManager() {
        return queryManager;
    }

    public static List<GCUBEXMLResource> getDeletedResources() {
        return deletedResources;
    }

    public void printEnv() {
        Properties p = System.getProperties();
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            logger.debug(keys.nextElement());
        }
        logger.debug((Object)("Exist home: " + System.getProperty("exist.home")));
    }

    static {
        deletedResources = Collections.synchronizedList(new ArrayList());
        logger = new GCUBELog(State.class);
        isInitialized = false;
    }
}

