/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.exist;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.xmlstorage.backup.BackupFolder;

public class ExistBackupFolder
extends BackupFolder {
    private static final long serialVersionUID = -6676338091088430159L;
    private static final GCUBELog logger = new GCUBELog(ExistBackupFolder.class);

    public ExistBackupFolder(String pathname) throws IOException {
        super(pathname);
    }

    protected static FileFilter getBackupFolderFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File dir) {
                logger.trace((Object)("Checking eXist root folder: " + dir.getName()));
                File archive = ExistBackupFolder.lookForZipArchive(dir);
                return archive != null;
            }
        };
    }

    private static File lookForZipArchive(File filein) {
        File[] files;
        for (File file : files = filein.listFiles()) {
            logger.trace((Object)("Checking eXist backup file: " + file.getName()));
            if (!file.getName().endsWith(".zip") && !file.getName().endsWith(".ZIP") || !file.getName().startsWith("full") && !file.getName().startsWith("FULL")) continue;
            return file;
        }
        return null;
    }

    protected File getBackupFile() throws IOException {
        File archive = ExistBackupFolder.lookForZipArchive(this);
        if (archive != null) {
            logger.trace((Object)("Valid ZIP archive found in " + archive.getAbsolutePath()));
            return archive;
        }
        throw new IOException("the eXist backup in " + this.getAbsolutePath() + " is not valid: no ZIP archive has been found inside");
    }
}

