/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.backup;

import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class Scheduler
implements Runnable {
    protected static GCUBELog logger = new GCUBELog(Scheduler.class);
    private int intervalInMS = 86400000;

    public Scheduler(int intervalInHours) {
        this.intervalInMS = intervalInHours * 3600 * 1000;
        logger.info((Object)("Scheduler will work every " + intervalInHours + " hour(s)"));
    }

    public Scheduler() {
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.intervalInMS);
            this.doBackup();
        }
        catch (InterruptedException e) {
            logger.error((Object)"Unable to sleep (yawn)", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to backup", (Throwable)e);
        }
    }

    protected abstract void doBackup() throws Exception;

    public int getIntervalInMS() {
        return this.intervalInMS;
    }
}

