/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.xmlstorage.backup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.contexts.ICServiceContext;
import org.gcube.informationsystem.collector.impl.xmlstorage.backup.BackupFolder;

public class BackupsRootFolder {
    private static final long serialVersionUID = 6054398926161291140L;
    private static File rootFolder;
    private static int maxBackups;
    private static GCUBELog logger;

    public static BackupFolder createBackupFolder() throws IOException {
        String backupFolder = rootFolder.getAbsolutePath() + File.separator + BackupsRootFolder.buildBackupFolderName();
        File backup = new File(backupFolder);
        if (!backup.mkdirs()) {
            throw new IOException("Unable to create the backup folder");
        }
        return new BackupFolder(backup.getAbsolutePath());
    }

    public static void manageOldBackups(FileFilter ... filter) throws IOException {
        if (maxBackups <= 0) {
            return;
        }
        if (!rootFolder.exists()) {
            throw new IOException("Unable to read the backup folder");
        }
        File[] files = filter != null && filter.length > 0 ? rootFolder.listFiles(filter[0]) : rootFolder.listFiles();
        logger.trace((Object)("Number of backups found:" + files.length));
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return new Long(file2.lastModified()).compareTo(new Long(file1.lastModified()));
            }
        });
        for (int i = maxBackups; i < files.length; ++i) {
            BackupsRootFolder.deleteBackup(files[i]);
        }
    }

    public static <T extends BackupFolder> T getLastBackup(Class<T> backupType, FileFilter ... filter) throws IOException {
        if (!rootFolder.exists()) {
            throw new IOException("Unable to read the backup folder");
        }
        File[] files = filter != null && filter.length > 0 ? rootFolder.listFiles(filter[0]) : rootFolder.listFiles();
        long lastModified = 0L;
        File lastBackup = null;
        for (File file : files) {
            logger.trace((Object)("Checking backup content: " + file.getAbsolutePath()));
            if (file.lastModified() < lastModified) continue;
            try {
                Class<?> clazz = Class.forName(backupType.getName());
                Constructor<?> constructor = clazz.getConstructor(String.class);
                lastBackup = (BackupFolder)constructor.newInstance(file.getAbsolutePath());
            }
            catch (Exception e) {
                logger.warn((Object)("invalid backup folder (" + file.getAbsolutePath() + ")"), (Throwable)e);
            }
        }
        if (lastBackup == null) {
            throw new IOException("Unable to find a valid backup folder");
        }
        logger.info((Object)("last backup found in " + lastBackup.getAbsolutePath()));
        return (T)lastBackup;
    }

    private static String buildBackupFolderName() {
        Calendar date = Calendar.getInstance();
        StringBuilder name = new StringBuilder();
        name.append(date.get(5));
        name.append("-");
        name.append(Calendar.getInstance().get(2) + 1);
        name.append("-");
        name.append(Calendar.getInstance().get(1));
        name.append("-");
        name.append(System.currentTimeMillis());
        return name.toString();
    }

    private static boolean deleteBackup(File backup) {
        if (backup.isDirectory()) {
            String[] children = backup.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = BackupsRootFolder.deleteBackup(new File(backup, children[i]));
                if (success) continue;
                return false;
            }
        }
        return backup.delete();
    }

    static {
        maxBackups = Integer.valueOf((String)ICServiceContext.getContext().getProperty("maxBackups", new boolean[]{true}));
        logger = new GCUBELog(BackupsRootFolder.class);
        String backupDir = (String)ICServiceContext.getContext().getProperty("backupDir", new boolean[]{true});
        rootFolder = new File(backupDir);
        if (!rootFolder.isAbsolute()) {
            backupDir = ICServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + File.separator + backupDir + File.separator;
            rootFolder = new File(backupDir);
        }
    }
}

