/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.utils;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.encoding.AnyContentType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.utils.AnyHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class MsgParser {
    private Document internalDOM;
    private String originalMsgString;
    private String type;
    private XPath path = XPathFactory.newInstance().newXPath();
    private final String rootElement = "Data";
    private final String typeElement = "Type";
    private static GCUBELog logger = new GCUBELog(MsgParser.class);

    public MsgParser(AnyContentType deliveredMsg) throws Exception {
        try {
            this.originalMsgString = AnyHelper.toSingleString((AnyContentType)deliveredMsg);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader("<Data>" + this.originalMsgString + "</" + "Data" + ">");
            InputSource source = new InputSource(reader);
            this.internalDOM = builder.parse(source);
            this.checkMsgType();
            this.type = this.path.evaluate("//Data/child::*[local-name() = 'Type']", this.internalDOM);
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"", (Throwable)pce);
            throw new Exception("Parser configuration error");
        }
        catch (SAXParseException spe) {
            logger.error((Object)"", (Throwable)spe);
            throw new Exception(" SAX parser error");
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)"", (Throwable)xpee);
            throw new Exception("XPath evaluation error");
        }
    }

    public String getEntryType() {
        return this.type;
    }

    public String getScopeName() throws Exception {
        return this.getGCUBEProperty("Scope");
    }

    public String getServiceName() throws Exception {
        return this.getGCUBEProperty("ServiceName");
    }

    public String getServiceClass() throws Exception {
        return this.getGCUBEProperty("ServiceClass");
    }

    public String getRunningInstanceID() throws Exception {
        return this.getGCUBEProperty("RunningInstanceID");
    }

    public String getServiceID() throws Exception {
        return this.getGCUBEProperty("ServiceID");
    }

    public String getGHNID() throws Exception {
        return this.getGCUBEProperty("GHN");
    }

    public String getProfile() throws Exception {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(this.internalDOM.getElementsByTagName("Resource").item(0)), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (Exception e) {
            throw new Exception("Unable to deserialise content data");
        }
    }

    private String getGCUBEProperty(String propName) throws Exception {
        try {
            return this.path.evaluate("//Data/child::*[local-name() = '" + propName + "']", this.internalDOM);
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)"", (Throwable)xpee);
            throw new Exception("XPath evaluation error");
        }
    }

    public String getEntryAsString() {
        return this.originalMsgString;
    }

    public void dispose() {
        this.internalDOM = null;
    }

    private void checkMsgType() throws Exception {
        Boolean isPush = false;
        String notificationXpath = "/child::*[local-name() = 'value']";
        notificationXpath = notificationXpath + "/child::*[local-name() = 'ResourcePropertyValueChangeNotification']";
        notificationXpath = notificationXpath + "/child::*[local-name() = 'NewValue']";
        try {
            isPush = (Boolean)this.path.evaluate("//Data" + notificationXpath, this.internalDOM, XPathConstants.BOOLEAN);
        }
        catch (NullPointerException n) {
            logger.trace((Object)"The delivered message has been sent using the pull mode");
            return;
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)"", (Throwable)xpee);
        }
        if (isPush.booleanValue()) {
            logger.trace((Object)"The delivered message has been sent using the push mode");
            Node node = (Node)this.path.evaluate("//Data" + notificationXpath, this.internalDOM, XPathConstants.NODE);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = factory.newDocumentBuilder();
            NodeList children = node.getChildNodes();
            this.originalMsgString = "";
            if (children != null) {
                for (int i = 0; i < children.getLength(); ++i) {
                    serializer.transform(new DOMSource(children.item(i)), new StreamResult(sw));
                    this.originalMsgString = this.originalMsgString + sw.toString();
                }
            }
            logger.trace((Object)("Data string " + this.originalMsgString));
            this.originalMsgString = this.originalMsgString.substring(this.originalMsgString.indexOf("?>", 1) + 1);
            logger.trace((Object)("Trimmed data string " + this.originalMsgString));
            StringReader reader = new StringReader("<Data>" + this.originalMsgString + "</" + "Data" + ">");
            InputSource source = new InputSource(reader);
            this.internalDOM = domBuilder.parse(source);
        } else {
            logger.info((Object)"The delivered message has been sent using the pull mode");
        }
    }
}

