/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.w3c.dom.Document;

public class MetadataReader {
    private Document metadata;

    public MetadataReader(Document metadata) {
        this.metadata = metadata;
    }

    public String getType() {
        try {
            return this.metadata.getElementsByTagName("Type").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getSource() {
        try {
            return this.metadata.getElementsByTagName("Source").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Calendar getTerminationTime() {
        try {
            String value = this.metadata.getElementsByTagName("TimeToLive").item(0).getTextContent();
            GregorianCalendar now = new GregorianCalendar();
            ((Calendar)now).setTimeZone(TimeZone.getTimeZone("GMT"));
            ((Calendar)now).add(13, Integer.valueOf(value));
            return now;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getGroupKey() {
        try {
            return this.metadata.getElementsByTagName("GroupKey").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEntryKey() {
        try {
            return this.metadata.getElementsByTagName("EntryKey").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getKey() {
        try {
            return this.metadata.getElementsByTagName("Key").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getPublicationMode() {
        try {
            return this.metadata.getElementsByTagName("PublicationMode").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getNamespace() {
        try {
            return this.metadata.getElementsByTagName("Namespace").item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }
}

