/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.utils;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.gcube.informationsystem.collector.impl.utils.EntryEPRParser;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;

public class EntryParser {
    private AggregatorServiceGroupEntryResource entry = null;
    private static final String registryNS = "gcube/informationsystem/registry/Registry";

    public EntryParser(AggregatorServiceGroupEntryResource entry) {
        this.entry = entry;
    }

    public EndpointReferenceType getSource() {
        return this.entry.getMemberEPR();
    }

    public EndpointReferenceType getSink() {
        return this.entry.getEntryEPR();
    }

    public String getSourceKey() {
        String key = "";
        EndpointReferenceType memberEpr = this.entry.getMemberEPR();
        try {
            MessageElement[] any;
            ReferencePropertiesType prop = memberEpr.getProperties();
            if (prop != null && (any = prop.get_any()).length > 0) {
                key = any[0].getValue();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return key;
    }

    public String getQualifiedSourceKey() {
        String key = "";
        EndpointReferenceType memberEpr = this.entry.getMemberEPR();
        try {
            MessageElement[] any;
            ReferencePropertiesType prop = memberEpr.getProperties();
            if (prop != null && (any = prop.get_any()).length > 0) {
                key = any[0].toString();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return key;
    }

    public String getSourceURI() {
        EndpointReferenceType memberEpr = this.entry.getMemberEPR();
        return memberEpr.getAddress().toString();
    }

    public String getType() {
        EndpointReferenceType memberEpr = this.entry.getMemberEPR();
        if (memberEpr.getAddress().toString().endsWith(registryNS)) {
            return "Profile";
        }
        return "Properties";
    }

    public void getRPSet() {
    }

    public EntryEPRParser getEPRSinkParser() throws Exception {
        return new EntryEPRParser(this.entry.getEntryEPR());
    }

    public static enum RESOURCETYPE {
        Profile,
        Properties;

    }
}

