/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.state;

import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.AnyContentType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.resources.BaseDAIXResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEInstanceStateResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEProfileResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEXMLResource;
import org.gcube.informationsystem.collector.impl.state.ICRegisteredResource;
import org.gcube.informationsystem.collector.impl.utils.EntryEPRParser;
import org.gcube.informationsystem.collector.impl.utils.EntryParser;
import org.gcube.informationsystem.collector.impl.utils.Identifier;
import org.gcube.informationsystem.collector.impl.utils.MsgParser;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupResource;
import org.globus.mds.aggregator.impl.AggregatorSink;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleTopicList;
import org.globus.wsrf.impl.servicegroup.EntryResourcePropertyTopic;
import org.globus.wsrf.impl.servicegroup.ServiceGroupConstants;

public class AggregatorRegisteredResource
extends AggregatorServiceGroupResource
implements AggregatorSink,
ICRegisteredResource {
    private static GCUBELog logger = new GCUBELog(AggregatorRegisteredResource.class);
    private ResourceKey resourceKey = null;
    protected Calendar terminationTime;
    protected Calendar currentTime;
    private ResourcePropertySet propSet;
    private TopicList topicList;
    public static final QName RP_SET = new QName("http://gcube-system.org/namespaces/informationsystem/collector/XMLCollectionAccess", "ICRP");

    public AggregatorRegisteredResource() {
        super.init(RP_SET);
        this.propSet = this.getResourcePropertySet();
        this.topicList = new SimpleTopicList((ResourceProperties)this);
        ReflectionResourceProperty prop = null;
        EntryResourcePropertyTopic rpTopic = new EntryResourcePropertyTopic(this.propSet.get(ServiceGroupConstants.ENTRY));
        this.propSet.add((ResourceProperty)rpTopic);
        this.topicList.addTopic((Topic)rpTopic);
        try {
            prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.TERMINATION_TIME, (Object)this);
            this.propSet.add((ResourceProperty)prop);
            prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this);
            this.propSet.add((ResourceProperty)prop);
            this.propSet.add((ResourceProperty)prop);
            this.loadCompatibleSources(this);
        }
        catch (Exception e) {
            logger.error((Object)"Error during DISICResource creation: ", (Throwable)e);
        }
    }

    public void setResourceKey(ResourceKey k) throws Exception {
        if (this.resourceKey != null) {
            throw new Exception("Resource key can only be set once.");
        }
        this.resourceKey = k;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void setTerminationTime(Calendar time) {
        logger.debug((Object)("Set Termination time called: " + time.getTime()));
        this.terminationTime = time;
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    public TopicList getTopicList() {
        return this.topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(AnyContentType messageObj, AggregatorServiceGroupEntryResource entry) {
        logger.info((Object)"New delivered resource");
        try {
            BaseDAIXResource resource;
            MsgParser aentry = new MsgParser(messageObj);
            String entryType = aentry.getEntryType();
            logger.debug((Object)("Entry type " + entryType));
            logger.debug((Object)("Entry RunningInstance ID " + aentry.getRunningInstanceID()));
            logger.debug((Object)("Entry Service Name " + aentry.getServiceName()));
            logger.debug((Object)("Entry Service Class " + aentry.getServiceClass()));
            EntryParser entryparser = new EntryParser(entry);
            EntryEPRParser sinkparser = entryparser.getEPRSinkParser();
            logger.debug((Object)("Aggregator Source " + entryparser.getSource()));
            logger.debug((Object)("Aggregator Sink " + entryparser.getSink()));
            logger.debug((Object)"Storing the new delivered resource");
            if (entryparser.getType().compareToIgnoreCase("Profile") == 0) {
                resource = new GCUBEProfileResource();
                String profile = aentry.getProfile();
                resource.setResourceName(Identifier.buildProfileID(profile));
                resource.setContent(profile);
            } else {
                resource = new GCUBEInstanceStateResource();
                resource.setResourceName(Identifier.buildInstanceStateID(entryparser));
                resource.setContent(aentry.getEntryAsString());
            }
            GCUBEXMLResource res = new GCUBEXMLResource(resource);
            res.setEntryKey(sinkparser.getEntryKey());
            res.setGroupKey(sinkparser.getGroupKey());
            res.setTerminationTime(entry.getTerminationTime());
            res.setSource(entryparser.getSourceURI());
            res.setSourceKey(entryparser.getSourceKey());
            logger.debug((Object)("Qualified Source Key: " + entryparser.getQualifiedSourceKey()));
            res.setNamespace("");
            List<GCUBEXMLResource> list = State.deletedResources;
            synchronized (list) {
                if (State.deletedResources.contains(res)) {
                    State.deletedResources.remove(res);
                    throw new Exception("the resource " + res.getResourceName() + " is no longer available");
                }
            }
            logger.trace((Object)("Resource: " + res.toString()));
            State.getDataManager().storeResource(res);
            aentry.dispose();
            logger.info((Object)"Delivered resource stored with success");
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred when managing aggregator content, the resource has NOT be stored successfully", (Throwable)e);
        }
    }

    public void initialize(Object parameters) {
    }

    public void setSource(AggregatorSource source) {
    }

    public AggregatorSource getSource() {
        return null;
    }

    public void terminate() {
        logger.debug((Object)"Resource terminated");
    }

    public void remove() {
        logger.debug((Object)"Resource removed");
    }
}

