/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.resources;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.resources.DAIXResource;
import org.gcube.informationsystem.collector.impl.resources.GCUBEInstanceStateResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GCUBEXMLResource {
    protected RESOURCETYPE type = null;
    protected static GCUBELog logger = new GCUBELog(GCUBEXMLResource.class);
    protected Calendar terminationTime = null;
    protected Calendar lastUpdateTime = null;
    protected String entryKey;
    protected String groupKey;
    protected String source;
    protected String sourceKey = "";
    protected String namespace = "";
    protected static XPath path = XPathFactory.newInstance().newXPath();
    protected static Transformer transformer;
    private DAIXResource resource;
    private String publicationMode = "";

    public GCUBEXMLResource(DAIXResource resource) throws MalformedXMLResourceException {
        this.resource = resource;
        this.terminationTime = new GregorianCalendar();
        this.terminationTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.lastUpdateTime = new GregorianCalendar();
        this.lastUpdateTime.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            if (resource.getResourceName() == null) {
                throw new MalformedXMLResourceException("Invalid resource name");
            }
        }
        catch (DAIXResource.MalformedResourceException e) {
            throw new MalformedXMLResourceException("Invalid resource name");
        }
    }

    public String getCollectionName() throws MalformedXMLResourceException {
        try {
            return this.resource.getCollectionName();
        }
        catch (DAIXResource.MalformedResourceException e) {
            throw new MalformedXMLResourceException(e);
        }
    }

    public String getResourceName() throws MalformedXMLResourceException {
        try {
            return this.resource.getResourceName();
        }
        catch (DAIXResource.MalformedResourceException e) {
            throw new MalformedXMLResourceException(e);
        }
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setTerminationTime(Calendar terminationTime) {
        this.terminationTime = (Calendar)terminationTime.clone();
        this.terminationTime.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public long getLastUpdateTimeinMills() throws DAIXResource.MalformedResourceException {
        if (this.lastUpdateTime != null) {
            return this.lastUpdateTime.getTimeInMillis();
        }
        throw new DAIXResource.MalformedResourceException("unable to retrieve last update time for resource " + this.resource.getResourceName());
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public String getPublicationMode() {
        return this.publicationMode;
    }

    public void setSourceKey(String key) {
        this.sourceKey = key;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPublicationMode(String publicationMode) {
        this.publicationMode = publicationMode;
    }

    public void deserializeFromIndexing(String content, boolean ... enveloped) {
        try {
            if (enveloped != null && enveloped.length > 0 && enveloped[0]) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringReader reader = new StringReader(content);
                InputSource source = new InputSource(reader);
                Document doc = builder.parse(source);
                this.parseEnvelop(doc);
                this.resource.deserializeFromIndexing(this.removeEnvelop(doc));
            } else {
                this.resource.deserializeFromIndexing(content);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseEnvelop(Document doc) throws MalformedXMLResourceException {
        String value = "";
        try {
            value = path.evaluate("Document/LastUpdateMs", doc);
            this.lastUpdateTime.setTimeInMillis(Long.parseLong(value));
            value = path.evaluate("Document/TerminationTime", doc);
            this.terminationTime.setTimeInMillis(Long.parseLong(value));
            value = path.evaluate("Document/Source", doc);
            this.setSource(value);
            value = path.evaluate("Document/SourceKey", doc);
            this.setSourceKey(value);
            value = path.evaluate("Document/EntryKey", doc);
            this.setEntryKey(value);
            value = path.evaluate("Document/GroupKey", doc);
            this.setGroupKey(value);
            value = path.evaluate("Document/Namespace", doc);
            this.setNamespace(value);
            value = path.evaluate("Document/PublicationMode", doc);
            this.setPublicationMode(value);
        }
        catch (Exception xpee) {
            logger.error((Object)("" + xpee.getMessage()));
            logger.error((Object)("" + xpee.getStackTrace()));
            throw new MalformedXMLResourceException("Unable to retrieve last update time for resource");
        }
    }

    public String toString() {
        StringBuilder resource = new StringBuilder("<Document>\n");
        try {
            resource.append("<ID>" + this.resource.getResourceName() + "</ID>\n");
            resource.append("<Source>" + this.getSource() + "</Source>\n");
            resource.append("<SourceKey>" + this.getSourceKey() + "</SourceKey>\n");
            if (this.getNamespace() != null && this.getNamespace().length() > 0) {
                String completeKey = "<ns1:ResourceKey xmlns:ns1=\"NS\">KEY</ns1:ResourceKey>";
                completeKey = completeKey.replace("NS", this.getNamespace());
                completeKey = completeKey.replace("KEY", this.getSourceKey());
                resource.append("<CompleteSourceKey>" + completeKey + "</CompleteSourceKey>\n");
            } else {
                resource.append("<CompleteSourceKey></CompleteSourceKey>\n");
            }
            resource.append("<EntryKey>" + this.getEntryKey() + "</EntryKey>\n");
            resource.append("<GroupKey>" + this.getGroupKey() + "</GroupKey>\n");
            resource.append("<TerminationTime>" + this.getTerminationTime().getTimeInMillis() + "</TerminationTime>\n");
            resource.append("<TerminationTimeHuman>" + this.getTerminationTime().getTime().toString() + "</TerminationTimeHuman>\n");
            resource.append("<LastUpdateMs>" + this.lastUpdateTime.getTimeInMillis() + "</LastUpdateMs>\n");
            resource.append("<LastUpdateHuman>" + this.lastUpdateTime.getTime().toString() + "</LastUpdateHuman>\n");
            resource.append("<PublicationMode>" + this.publicationMode + "</PublicationMode>\n");
            resource.append("<Data>\n");
            if (this.resource instanceof GCUBEInstanceStateResource) {
                if (this.resource.toString().startsWith("<ResourceProperties")) {
                    resource.append(this.resource.toStringFromElement("ResourceProperties") + "\n");
                } else {
                    resource.append(this.resource.serializeForIndexing() + "\n");
                }
            } else {
                resource.append(this.resource.serializeForIndexing() + "\n");
            }
            resource.append("</Data>\n");
            resource.append("</Document>");
        }
        catch (DAIXResource.MalformedResourceException e) {
            logger.error((Object)"invalid content", (Throwable)e);
            throw new RuntimeException("invalid content");
        }
        return resource.toString();
    }

    private String removeEnvelop(Document doc) throws MalformedXMLResourceException {
        try {
            return this.toStringFromElement(doc, "Data");
        }
        catch (Exception e) {
            logger.error((Object)"unable to retrieve parse the resource's content ", (Throwable)e);
            throw new MalformedXMLResourceException("unable to retrieve parse the resource's content");
        }
    }

    public String toStringFromElement(Document xml, String elementName) throws MalformedXMLResourceException {
        try {
            Node targetNode = xml.getElementsByTagName(elementName).item(0);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringBuilder ret = new StringBuilder();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            int index = 0;
            Node node = targetNode.getChildNodes().item(index);
            while (node != null) {
                StringWriter buffer = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(buffer));
                ret.append(buffer.toString().trim());
                node = targetNode.getChildNodes().item(index++);
            }
            return ret.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to deserialise content data", (Throwable)e);
            throw new MalformedXMLResourceException("Unable to deserialise the resource");
        }
    }

    public Document getContent() throws MalformedXMLResourceException {
        try {
            return this.resource.getContent();
        }
        catch (Exception e) {
            try {
                StringBuilder resource = new StringBuilder("<Data>\n");
                resource.append(this.resource.toString() + "\n");
                resource.append("</Data>\n");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringReader reader = new StringReader(resource.toString());
                InputSource source = new InputSource(reader);
                return builder.parse(source);
            }
            catch (Exception e2) {
                logger.error((Object)"Invalid data", (Throwable)e2);
                throw new MalformedXMLResourceException("Invalid data");
            }
        }
    }

    public String getSourceRunningInstance() throws Exception {
        try {
            if (transformer == null) {
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            ArrayList<String> results = new ArrayList<String>();
            NodeList set = (NodeList)path.evaluate("/RI/text()", this.resource.getContent(), XPathConstants.NODESET);
            for (int i = 0; i < set.getLength(); ++i) {
                StreamResult sr = new StreamResult(new StringWriter());
                try {
                    transformer.transform(new DOMSource(set.item(i)), sr);
                }
                catch (Exception ignore) {
                    continue;
                }
                results.add(sr.getWriter().toString());
            }
            return (String)results.get(0);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get RIID", (Throwable)e);
            throw e;
        }
    }

    public static class MalformedXMLResourceException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MalformedXMLResourceException(Exception e) {
            super(e);
        }

        public MalformedXMLResourceException(String message) {
            super(message);
        }
    }

    public static enum RESOURCETYPE {
        Profile,
        Properties;

    }
}

