/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.impl.porttypes;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.collector.impl.contexts.ICServiceContext;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.State;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XMLStorage;
import org.gcube.informationsystem.collector.impl.xmlstorage.exist.XQuery;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteRequest;
import org.gcube.informationsystem.collector.stubs.XQueryExecuteResponse;
import org.gcube.informationsystem.collector.stubs.XQueryFaultType;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class XQueryAccess
extends GCUBEPortType {
    private final GCUBELog logger = new GCUBELog(XQueryAccess.class);

    protected GCUBEServiceContext getServiceContext() {
        return ICServiceContext.getContext();
    }

    public XQueryExecuteResponse XQueryExecute(XQueryExecuteRequest request) throws XQueryFaultType {
        XQueryExecuteResponse response = new XQueryExecuteResponse();
        try {
            this.logger.debug((Object)("executing XQuery: " + request.getXQueryExpression()));
            XQuery q = new XQuery(request.getXQueryExpression());
            ResourceSet result = State.getQueryManager().executeXQuery(q);
            response.setSize(result.getSize());
            this.logger.debug((Object)("number of returned documents: " + result.getSize()));
            response.setDataset(this.buildDataSet(result));
        }
        catch (XMLStorage.XMLStorageNotAvailableException e) {
            XQueryFaultType fault = new XQueryFaultType();
            fault.addFaultDetailString("XMLStorage is not currently available for XQuery execution");
            throw fault;
        }
        catch (Exception e) {
            XQueryFaultType fault = new XQueryFaultType();
            fault.addFaultDetailString("Exception when executing the requested XQuery");
            throw fault;
        }
        return response;
    }

    private String buildDataSet(ResourceSet result) throws Exception {
        String rootElement = "Resultset";
        String recordElement = "Record";
        StringBuilder dataset = new StringBuilder();
        dataset.append("<Resultset>\n");
        for (int i = 0; i < (int)result.getSize(); ++i) {
            XMLResource xmlres = (XMLResource)result.getResource((long)i);
            dataset.append("<Record>\n" + xmlres.getContent() + "\n</" + "Record" + ">\n");
        }
        dataset.append("</Resultset>");
        return dataset.toString();
    }
}

