/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.relations;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryRelation;

public class JsonQueryIsRelatedTo
extends JsonQueryRelation {
    protected String requestedResourceType;

    public JsonQueryIsRelatedTo(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.IS_RELATED_TO);
    }

    public String getRequestedResourceType() {
        return this.requestedResourceType;
    }

    public void setRequestedResourceType(String requestedResourceType) {
        this.requestedResourceType = requestedResourceType;
    }

    private StringBuffer traverseThisEdge(StringBuffer stringBuffer) throws InvalidQueryException {
        StringBuffer buffer = new StringBuffer();
        int size = this.jsonNode.size();
        --size;
        if (this.jsonNode.has("source")) {
            --size;
        }
        if (this.jsonNode.has("target")) {
            --size;
        }
        if (size > 0) {
            buffer.append("SELECT FROM ");
            if (this.entryPoint) {
                buffer.append(this.type);
            } else {
                buffer.append(" ( ");
            }
        } else if (this.entryPoint) {
            buffer.append("SELECT FROM ");
            buffer.append(this.type);
        }
        if (!this.entryPoint) {
            buffer.append("TRAVERSE ");
            buffer.append(this.direction.opposite().name().toLowerCase());
            buffer.append("E(\"");
            buffer.append(this.type);
            buffer.append("\") FROM ( ");
            buffer.append(stringBuffer);
            buffer.append(")");
        }
        stringBuffer = buffer;
        if (size > 0) {
            if (!this.entryPoint) {
                stringBuffer.append(" )");
            }
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this.addConstraints(this.jsonNode, null, null));
        }
        return stringBuffer;
    }

    public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        JsonNode sourceJsonNode = this.jsonNode.get("source");
        JsonNode targetJsonNode = this.jsonNode.get("target");
        JsonNode resourceJsonNode = null;
        if (sourceJsonNode != null) {
            resourceJsonNode = sourceJsonNode;
            this.direction = Direction.OUT;
        } else if (targetJsonNode != null) {
            resourceJsonNode = targetJsonNode;
            this.direction = Direction.IN;
        }
        stringBuffer = this.traverseThisEdge(stringBuffer);
        JsonQueryResource jsonQueryResource = new JsonQueryResource(resourceJsonNode);
        jsonQueryResource.setDirection(this.direction);
        jsonQueryResource.setEntryPoint(false);
        stringBuffer = jsonQueryResource.analize(stringBuffer);
        StringBuffer buffer = new StringBuffer();
        if (this.requestedResourceType != null) {
            buffer.append("TRAVERSE ");
            buffer.append(this.direction.opposite().name().toLowerCase());
            buffer.append("V(\"");
            buffer.append(this.requestedResourceType);
            buffer.append("\") FROM ( ");
        }
        buffer.append("TRAVERSE ");
        buffer.append(this.direction.name().toLowerCase());
        buffer.append("E(\"");
        buffer.append(this.type);
        buffer.append("\") FROM ( ");
        buffer.append(stringBuffer);
        buffer.append(")");
        if (this.requestedResourceType != null) {
            buffer.append(")");
        }
        stringBuffer = buffer;
        if (sourceJsonNode != null && targetJsonNode != null) {
            jsonQueryResource = new JsonQueryResource(targetJsonNode);
            jsonQueryResource.setDirection(Direction.IN);
            jsonQueryResource.setEntryPoint(false);
            stringBuffer = jsonQueryResource.analize(stringBuffer);
            boolean entryPointOldValue = this.entryPoint;
            this.entryPoint = false;
            stringBuffer = this.traverseThisEdge(stringBuffer);
            this.entryPoint = entryPointOldValue;
        }
        return stringBuffer;
    }
}

