/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.security;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.ShadowContextSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowContextSecurityContext
extends SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    private static final String SHADOW_CONTEXT_SECURITY_CONTEXT = "cccccccc-cccc-cccc-cccc-cccccccccccc";
    private static final UUID SHADOW_CONTEXT_SECURITY_CONTEXT_UUID = UUID.fromString(SHADOW_CONTEXT_SECURITY_CONTEXT);
    private static ShadowContextSecurityContext instance;

    public static ShadowContextSecurityContext getInstance() throws ResourceRegistryException {
        if (instance == null) {
            instance = new ShadowContextSecurityContext();
            ContextUtility contextUtility = ContextUtility.getInstance();
            contextUtility.addSecurityContext(SHADOW_CONTEXT_SECURITY_CONTEXT, (SecurityContext)instance);
        }
        return instance;
    }

    private ShadowContextSecurityContext() throws ResourceRegistryException {
        super(SHADOW_CONTEXT_SECURITY_CONTEXT_UUID, false);
    }

    protected boolean isHierarchicalMode() {
        return false;
    }

    protected ORole addExtraRules(ORole role, SecurityContext.PermissionMode permissionMode) {
        logger.trace("Adding extra rules for {}", (Object)role.getName());
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$contexts$security$SecurityContext$PermissionMode[permissionMode.ordinal()]) {
            case 1: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
                break;
            }
            case 2: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
                break;
            }
        }
        return role;
    }
}

