/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="contexts")
public class ContextManager {
    public static final String CONTEXT_UUID_PATH_PARAMETER = "CONTEXT_UUID";
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);

    public ContextManager() {
        ContextUtility.getHierarchicalMode().set(false);
        ContextUtility.getIncludeInstanceContexts().set(false);
    }

    @GET
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String all() throws ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to read all {}s", (Object)"Context");
        CalledMethodProvider.instance.set("listContexts");
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="CONTEXT_UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentSecurityContext().getUUID().toString();
        }
        logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        CalledMethodProvider.instance.set("readContext");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.readAsString();
    }

    @PUT
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateCreate(@PathParam(value="CONTEXT_UUID") String uuid, String json) throws ResourceRegistryException {
        logger.info("Requested to update/create {} with json {} ", (Object)"Context", (Object)json);
        CalledMethodProvider.instance.set("updateContext");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.setJson(json);
        return contextManagement.createOrUpdate();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{CONTEXT_UUID}")
    public Response delete(@PathParam(value="CONTEXT_UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        CalledMethodProvider.instance.set("deleteContext");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

