/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.types.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="types")
public class TypeManager {
    private static Logger logger = LoggerFactory.getLogger(TypeManager.class);
    public static final String TYPE_PATH_PARAMETER = "TYPE_NAME";

    public TypeManager() {
        ContextUtility.getHierarchicalMode().set(false);
        ContextUtility.getIncludeInstanceContexts().set(false);
    }

    @PUT
    @Path(value="{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(@PathParam(value="TYPE_NAME") String typeName, String json) throws SchemaException, ResourceRegistryException {
        logger.info("Requested {} creation with schema {}", (Object)typeName, (Object)json);
        CalledMethodProvider.instance.set("createType");
        TypeManagement schemaManagement = new TypeManagement();
        schemaManagement.setTypeName(typeName);
        schemaManagement.setJson(json);
        String ret = schemaManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @GET
    @Path(value="{TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        logger.info("Requested Schema for type {}", (Object)type);
        CalledMethodProvider.instance.set("readType");
        TypeManagement schemaManagement = new TypeManagement();
        schemaManagement.setTypeName(type);
        List types = schemaManagement.read(polymorphic.booleanValue());
        try {
            return TypeMapper.serializeTypeDefinitions((List)types);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }
}

