/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.queries.templates.QueryTemplateManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="query-templates")
public class QueryTemplateManager {
    private static Logger logger = LoggerFactory.getLogger(QueryTemplateManager.class);
    public static final String QUERY_TEMPLATE_NAME_PATH_PARAMETER = "QUERY_TEMPLATE_NAME";

    @GET
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String all() throws NotFoundException, ResourceRegistryException {
        logger.info("Requested to read all {}s", (Object)"QueryTemplate");
        CalledMethodProvider.instance.set("listQueryTemplates");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        return queryTemplateManagement.all(false);
    }

    @PUT
    @Path(value="{QUERY_TEMPLATE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateCreate(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName, String json) throws InvalidQueryException, ResourceRegistryException {
        logger.info("Requested {} creation with name {} and content {}", new Object[]{"QueryTemplate", queryTemplateName, json});
        CalledMethodProvider.instance.set("createQueryTemplate");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setJson(json);
        String ret = queryTemplateManagement.createOrUpdate();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @GET
    @Path(value="{QUERY_TEMPLATE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        CalledMethodProvider.instance.set("readQueryTemplate");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        return queryTemplateManagement.read();
    }

    @POST
    @Path(value="{QUERY_TEMPLATE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String run(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName, String params) throws NotFoundException, InvalidQueryException, ResourceRegistryException {
        logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        CalledMethodProvider.instance.set("readQueryTemplate");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setParams(params);
        return queryTemplateManagement.run();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{QUERY_TEMPLATE_NAME}")
    public Response delete(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested to delete {} with name {} ", (Object)"QueryTemplate", (Object)queryTemplateName);
        CalledMethodProvider.instance.set("deleteQueryTemplate");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

