/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.activation.UnsupportedDataTypeException;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.BooleanNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.properties.PropertyElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.HeaderOrient;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ElementManagement<El extends OElement, T extends Type> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DELETED = "deleted";
    public static final String AT = "@";
    public static final String UNDERSCORE = "_";
    protected final Set<String> ignoreKeys;
    protected final Set<String> ignoreStartWithKeys;
    protected Class<El> elementClass;
    protected final AccessType accessType;
    protected ODatabaseDocument oDatabaseDocument;
    protected UUID uuid;
    protected JsonNode jsonNode;
    protected OClass oClass;
    protected String typeName;
    protected JsonNode self;
    protected JsonNode complete;
    protected CachedType<T> cachedType;
    protected El element;
    protected boolean reload;
    protected boolean dryRun;
    protected boolean entryPoint;
    protected Operation operation;
    protected final Map<UUID, JsonNode> affectedInstances;
    protected SecurityContext workingContext;

    protected ElementManagement(AccessType accessType) {
        this.accessType = accessType;
        this.ignoreKeys = new HashSet();
        this.ignoreStartWithKeys = new HashSet();
        this.ignoreStartWithKeys.add("@");
        this.ignoreStartWithKeys.add("_");
        this.reload = false;
        this.entryPoint = false;
        this.operation = null;
        this.dryRun = false;
        this.affectedInstances = new HashMap();
    }

    public Map<UUID, JsonNode> getAffectedInstances() {
        return this.affectedInstances;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    protected void setAsEntryPoint() {
        this.entryPoint = true;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    protected void cleanCachedSerialization() {
        this.self = null;
        this.complete = null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getCurrentSecurityContext();
        }
        return this.workingContext;
    }

    public void setWorkingContext(SecurityContext workingContext) {
        this.workingContext = workingContext;
    }

    public void setUUID(UUID uuid) throws ResourceRegistryException {
        this.uuid = uuid;
        if (this.jsonNode != null) {
            this.checkUUIDMatch();
        }
    }

    public void setJsonNode(JsonNode jsonNode) throws ResourceRegistryException {
        this.jsonNode = jsonNode;
        this.checkJsonNode();
    }

    public void setJson(String json) throws ResourceRegistryException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.jsonNode = mapper.readTree(json);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        this.checkJsonNode();
    }

    public void setODatabaseDocument(ODatabaseDocument oDatabaseDocument) {
        this.oDatabaseDocument = oDatabaseDocument;
    }

    public void setOClass(OClass oClass) {
        this.oClass = oClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OClass getOClass() throws SchemaException, ResourceRegistryException {
        if (this.oClass != null) return this.oClass;
        if (this.element != null) {
            try {
                this.oClass = ElementManagementUtility.getOClass((OElement)this.element);
                if (this.typeName == null) {
                    this.typeName = this.oClass.getName();
                }
                this.getCachedType().setOClass(this.oClass);
                return this.oClass;
            }
            catch (ResourceRegistryException e) {
                try {
                    this.oClass = this.getCachedType().getOClass();
                    if (this.typeName != null) return this.oClass;
                    this.typeName = this.oClass.getName();
                    return this.oClass;
                }
                catch (Exception e1) {
                    throw e;
                }
            }
        } else {
            if (this.typeName == null) {
                throw new SchemaException("Unknown type name. Please set it first.");
            }
            this.oClass = this.getCachedType().getOClass();
            AccessType gotAccessType = this.cachedType.getAccessType();
            if (this.accessType == gotAccessType) return this.oClass;
            throw new SchemaException(this.typeName + " is not a " + this.accessType.getName());
        }
    }

    protected CachedType<T> getCachedType() {
        if (this.cachedType == null) {
            TypesCache typesCache = TypesCache.getInstance();
            this.cachedType = typesCache.getCachedType(this.typeName);
        }
        return this.cachedType;
    }

    public void setElementType(String elementType) throws ResourceRegistryException {
        if (this.typeName == null) {
            if (elementType == null || elementType.compareTo("") == 0) {
                elementType = this.accessType.getName();
            }
            this.typeName = elementType;
        } else if (elementType.compareTo(elementType) != 0) {
            throw new ResourceRegistryException("Provided type " + elementType + " does not match with the one already known " + this.accessType);
        }
        if (this.jsonNode != null) {
            this.checkERMatch();
        }
    }

    public String getTypeName() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        if (this.typeName == null) {
            if (this.element != null) {
                this.typeName = (String)this.element.getProperty("@class");
            }
            if (this.typeName == null && this.jsonNode != null) {
                this.typeName = ElementManagement.getClassProperty((JsonNode)this.jsonNode);
            }
            if (this.typeName == null) {
                this.typeName = this.getOClass().getName();
            }
        }
        return this.typeName;
    }

    protected void checkJsonNode() throws ResourceRegistryException {
        if (this.uuid == null) {
            try {
                this.uuid = org.gcube.informationsystem.utils.Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode);
            }
            catch (Exception exception) {}
        } else {
            this.checkUUIDMatch();
        }
        if (this.typeName == null) {
            this.typeName = ElementManagement.getClassProperty((JsonNode)this.jsonNode);
            this.getOClass();
        } else {
            this.checkERMatch();
        }
    }

    protected void checkERMatch() throws ResourceRegistryException {
        String type;
        if (this.jsonNode != null && (type = ElementManagement.getClassProperty((JsonNode)this.jsonNode)) != null && type.compareTo(this.typeName) != 0) {
            String error = String.format("Requested type does not match with json representation %s!=%s", this.typeName, type);
            this.logger.trace(error);
            throw new ResourceRegistryException(error);
        }
        this.getOClass();
    }

    protected void checkUUIDMatch() throws ResourceRegistryException {
        UUID resourceUUID;
        Header header = null;
        try {
            header = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)false);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        if (header != null && (resourceUUID = header.getUUID()).compareTo(this.uuid) != 0) {
            String error = String.format("UUID provided in header (%s) differs from the one (%s) used to identify the %s instance", resourceUUID.toString(), this.uuid.toString(), this.typeName);
            throw new ResourceRegistryException(error);
        }
    }

    private JsonNode createSelfJsonNode() throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode objectNode = objectMapper.createObjectNode();
            OElement element = this.getElement();
            Set keys = element.getPropertyNames();
            for (String key : keys) {
                Object object = element.getProperty(key);
                if (object == null) {
                    objectNode.replace(key, null);
                    continue;
                }
                JsonNode jsonNode = this.getPropertyForJson(key, object);
                if (jsonNode == null) continue;
                objectNode.replace(key, jsonNode);
            }
            objectNode.put("@class", this.getTypeName());
            List superClasses = this.getCachedType().getSuperTypes();
            ArrayNode arrayNode = (ArrayNode)objectMapper.valueToTree((Object)superClasses);
            objectNode.replace("@superClasses", (JsonNode)arrayNode);
            return objectNode;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + this.getElement().toString(), (Throwable)e);
        }
    }

    public JsonNode serializeAsAffectedInstance() throws ResourceRegistryException {
        return this.serializeSelfAsJsonNode();
    }

    public JsonNode serializeSelfAsJsonNode() throws ResourceRegistryException {
        try {
            if (this.self == null || this.reload) {
                this.self = this.createSelfJsonNode();
            }
            return this.self.deepCopy();
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected abstract JsonNode createCompleteJsonNode() throws ResourceRegistryException;

    public JsonNode serializeAsJsonNode() throws ResourceRegistryException {
        try {
            if (this.complete == null || this.reload) {
                this.complete = this.createCompleteJsonNode();
            }
            return this.complete;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected abstract El reallyCreate() throws AlreadyPresentException, ResourceRegistryException;

    public El internalCreate() throws AlreadyPresentException, ResourceRegistryException {
        try {
            this.setOperation(Operation.CREATE);
            this.reallyCreate();
            Header entityHeader = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)true);
            if (entityHeader != null) {
                this.element.setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((OElement)this.element, null);
                this.uuid = entityHeader.getUUID();
            }
            this.getWorkingContext().addElement(this.element, this.oDatabaseDocument);
            this.element.save();
            this.sanityCheck();
            return (El)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Creating " + this.typeName + " with " + this.jsonNode, (Throwable)e);
        }
    }

    protected abstract El reallyUpdate() throws NotFoundException, ResourceRegistryException;

    public El internalUpdate() throws NotFoundException, ResourceRegistryException {
        try {
            this.setOperation(Operation.UPDATE);
            this.reallyUpdate();
            HeaderUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            this.element.save();
            this.sanityCheck();
            return (El)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Updating " + this.typeName + " with " + this.jsonNode, (Throwable)e);
        }
    }

    public El internalCreateOrUdate() throws ResourceRegistryException {
        try {
            return (El)this.internalUpdate();
        }
        catch (NotFoundException e) {
            return (El)this.internalCreate();
        }
    }

    protected abstract void reallyDelete() throws NotFoundException, ResourceRegistryException;

    public void internalDelete() throws NotFoundException, ResourceRegistryException {
        this.setOperation(Operation.DELETE);
        this.reallyDelete();
        this.sanityCheck();
    }

    public void setElement(El element) throws ResourceRegistryException {
        if (element == null) {
            throw new ResourceRegistryException("Trying to set null " + this.elementClass.getSimpleName() + " in " + this);
        }
        this.element = element;
        this.uuid = HeaderUtility.getHeader(element).getUUID();
        OClass oClass = this.getOClass();
        this.typeName = oClass.getName();
    }

    protected abstract NotFoundException getSpecificNotFoundException(NotFoundException var1);

    protected abstract AlreadyPresentException getSpecificAlreadyPresentException(String var1);

    public El getElement() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            this.element.reload();
        }
        return (El)this.element;
    }

    public El retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.uuid == null) {
                throw new NotFoundException("null UUID does not allow to retrieve the Element");
            }
            return (El)Utility.getElementByUUID((ODatabaseDocument)this.oDatabaseDocument, (String)(this.typeName == null ? this.accessType.getName() : this.typeName), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (NotFoundException e) {
            throw this.getSpecificNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public El retrieveElementFromAnyContext() throws NotFoundException, ResourceRegistryException {
        try {
            return (El)Utility.getElementByUUIDAsAdmin((String)(this.typeName == null ? this.accessType.getName() : this.typeName), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (NotFoundException e) {
            throw this.getSpecificNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String reallyGetAll(boolean var1) throws ResourceRegistryException;

    public String all(boolean polymorphic) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.setAsEntryPoint();
            this.setOperation(Operation.QUERY);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public boolean exists() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.setAsEntryPoint();
            this.setOperation(Operation.EXISTS);
            this.getElement();
            boolean bl = true;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to find {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to find {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String createOrUpdate() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            boolean update = false;
            try {
                this.setAsEntryPoint();
                this.getElement();
                update = true;
                this.internalUpdate();
            }
            catch (NotFoundException e) {
                this.setAsEntryPoint();
                String calledMethod = CalledMethodProvider.instance.get();
                calledMethod = calledMethod.replace("update", "create");
                CalledMethodProvider.instance.set(calledMethod);
                this.internalCreate();
            }
            this.oDatabaseDocument.commit();
            if (update) {
                this.setReload(true);
            }
            String string = this.serializeAsJsonNode().toString();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String create() throws AlreadyPresentException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.internalCreate();
            this.oDatabaseDocument.commit();
            String string = this.serializeAsJsonNode().toString();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to create {}", (Object)this.accessType.getName());
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to create {}", (Object)this.accessType.getName(), (Object)e);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String read() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.setAsEntryPoint();
            this.setOperation(Operation.READ);
            this.getElement();
            String string = this.serializeAsJsonNode().toString();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to read {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to read {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String update() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.internalUpdate();
            this.oDatabaseDocument.commit();
            this.setReload(true);
            String string = this.serializeAsJsonNode().toString();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void delete() throws NotFoundException, AvailableInAnotherContextException, SchemaViolationException, ResourceRegistryException {
        this.logger.trace("Going to delete {} instance with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.internalDelete();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
                this.logger.info("{} with UUID {} was successfully deleted.", (Object)this.accessType.getName(), (Object)this.uuid);
            } else {
                this.oDatabaseDocument.rollback();
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to delete {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to delete {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public Set<String> getContextsSet() throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.trace("Going to get contexts for {} instance with UUID {}", (Object)this.typeName, (Object)this.uuid);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            Set contexts;
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            this.oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.setAsEntryPoint();
            this.setOperation(Operation.GET_METADATA);
            Set set = contexts = SecurityContext.getContexts((OElement)this.getElement());
            return set;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to get contexts for {} with UUID {}", new Object[]{this.typeName, this.uuid, e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to get contexts for {} with UUID {}", new Object[]{this.typeName, this.uuid, e});
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String getContexts() throws NotFoundException, ContextException, ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode objectNode = this.getContextsAsObjectNode(objectMapper);
            return objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException((Throwable)e);
        }
    }

    private ObjectNode getContextsAsObjectNode(ObjectMapper objectMapper) throws NotFoundException, ContextException, ResourceRegistryException {
        try {
            Set contexts = this.getContextsSet();
            ContextCache contextCache = ContextCache.getInstance();
            ObjectNode objectNode = objectMapper.createObjectNode();
            for (String contextUUID : contexts) {
                String contextFullName = contextCache.getContextFullNameByUUID(contextUUID);
                objectNode.put(contextUUID, contextFullName);
            }
            return objectNode;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException((Throwable)e);
        }
    }

    public ObjectNode getContextsAsObjectNode() throws NotFoundException, ContextException, ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        return this.getContextsAsObjectNode(objectMapper);
    }

    public static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    public static Object getObjectFromJsonNode(JsonNode value) throws UnsupportedDataTypeException, ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$org$gcube$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return PropertyElementManagement.getPropertyDocument((JsonNode)value);
            }
            case 2: {
                ArrayList<Object> list = new ArrayList<Object>();
                ArrayNode arrayNode = (ArrayNode)value;
                for (JsonNode node : arrayNode) {
                    list.add(ElementManagement.getObjectFromJsonNode((JsonNode)node));
                }
                return list;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public Map<String, JsonNode> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWith) throws JsonProcessingException, IOException {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (ignoreStartWith == null) {
            ignoreStartWith = new HashSet<String>();
        }
        Iterator fields = jsonNode.fields();
        block0: while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWith) {
                if (!key.startsWith(prefix)) continue;
                continue block0;
            }
            JsonNode value = (JsonNode)entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    public void setProperty(OProperty oProperty, String key, JsonNode value) throws Exception {
        switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oProperty.getType().ordinal()]) {
            case 1: {
                ODocument oDocument = PropertyElementManagement.getPropertyDocument((JsonNode)value);
                this.element.setProperty(key, (Object)oDocument, new OType[]{OType.EMBEDDED});
                break;
            }
            case 2: {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator arrayElement = value.elements();
                while (arrayElement.hasNext()) {
                    JsonNode elementOfArray = (JsonNode)arrayElement.next();
                    Object object = null;
                    object = oProperty.getLinkedType() != null ? ElementManagement.getObjectFromJsonNode((JsonNode)elementOfArray) : PropertyElementManagement.getPropertyDocument((JsonNode)elementOfArray);
                    list.add(object);
                }
                this.element.setProperty(key, list, new OType[]{OType.EMBEDDEDLIST});
                break;
            }
            case 3: {
                HashSet<Object> set = new HashSet<Object>();
                Iterator setElement = value.elements();
                while (setElement.hasNext()) {
                    JsonNode elementOfSet = (JsonNode)setElement.next();
                    Object object = null;
                    object = oProperty.getLinkedType() != null ? ElementManagement.getObjectFromJsonNode((JsonNode)elementOfSet) : PropertyElementManagement.getPropertyDocument((JsonNode)elementOfSet);
                    set.add(object);
                }
                this.element.setProperty(key, set, new OType[]{OType.EMBEDDEDSET});
                break;
            }
            case 4: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator fieldNames = value.fieldNames();
                while (fieldNames.hasNext()) {
                    String fieldKey = (String)fieldNames.next();
                    Object object = null;
                    object = oProperty.getLinkedType() != null ? ElementManagement.getObjectFromJsonNode((JsonNode)value.get(fieldKey)) : PropertyElementManagement.getPropertyDocument((JsonNode)value.get(fieldKey));
                    map.put(fieldKey, object);
                }
                this.element.setProperty(key, map, new OType[]{OType.EMBEDDEDMAP});
                break;
            }
            case 5: {
                if (value.getNodeType() == JsonNodeType.OBJECT) {
                    this.element.setProperty(key, (Object)value.toString());
                    break;
                }
                this.element.setProperty(key, ElementManagement.getObjectFromJsonNode((JsonNode)value));
                break;
            }
            default: {
                Object obj = ElementManagement.getObjectFromJsonNode((JsonNode)value);
                if (obj == null) break;
                this.element.setProperty(key, obj);
            }
        }
    }

    public OElement updateProperties(OClass oClass, OElement element, JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWithKeys) throws ResourceRegistryException {
        Map properties;
        Set oldKeys = element.getPropertyNames();
        try {
            properties = this.getPropertyMap(jsonNode, ignoreKeys, ignoreStartWithKeys);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        oldKeys.removeAll(properties.keySet());
        this.getOClass();
        for (String key : properties.keySet()) {
            try {
                if (key.compareTo("header") == 0) continue;
                JsonNode value = (JsonNode)properties.get(key);
                OProperty oProperty = oClass.getProperty(key);
                if (oProperty == null) {
                    Object object = ElementManagement.getObjectFromJsonNode((JsonNode)value);
                    if (object == null) continue;
                    if (object instanceof ODocument) {
                        element.setProperty(key, object, new OType[]{OType.EMBEDDED});
                        continue;
                    }
                    if (object instanceof List) {
                        element.setProperty(key, object, new OType[]{OType.EMBEDDEDLIST});
                        continue;
                    }
                    element.setProperty(key, object);
                    continue;
                }
                this.setProperty(oProperty, key, value);
            }
            catch (Exception e) {
                String error = String.format("Error while setting property %s : %s (%s)", key, ((JsonNode)properties.get(key)).toString(), e.getMessage());
                this.logger.error(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
        }
        block5: for (String key : oldKeys) {
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                continue block5;
            }
            element.removeProperty(key);
        }
        element.save();
        return element;
    }

    protected JsonNode getPropertyForJson(String key, Object object) throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper;
            if (object == null) {
                return null;
            }
            if (object instanceof JsonNode) {
                return (JsonNode)object;
            }
            if (key.compareTo("header") == 0) {
                HeaderOrient headerOrient = HeaderUtility.getHeaderOrient((ODocument)((ODocument)object));
                JsonNode headerJson = Utility.toJsonNode((OElement)headerOrient, (boolean)false);
                if (((Boolean)ContextUtility.getIncludeInstanceContexts().get()).booleanValue()) {
                    ((ObjectNode)headerJson).set("contexts", (JsonNode)this.getContextsAsObjectNode());
                }
                TypesCache typesCache = TypesCache.getInstance();
                CachedType headerType = typesCache.getCachedType("Header");
                ObjectMapper objectMapper2 = new ObjectMapper();
                List superClasses = headerType.getSuperTypes();
                ArrayNode arrayNode = (ArrayNode)objectMapper2.valueToTree((Object)superClasses);
                ((ObjectNode)headerJson).replace("@superClasses", (JsonNode)arrayNode);
                return headerJson;
            }
            if (this.ignoreKeys.contains(key)) {
                return null;
            }
            for (String prefix : this.ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                return null;
            }
            if (object instanceof ODocument) {
                ODocument oDocument = (ODocument)object;
                return PropertyElementManagement.getJsonNode((ODocument)oDocument);
            }
            if (object instanceof Date) {
                OProperty oProperty = this.getOClass().getProperty(key);
                OType oType = oProperty.getType();
                DateFormat dateFormat = ODateHelper.getDateTimeFormatInstance();
                switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                    case 6: {
                        dateFormat = ODateHelper.getDateFormatInstance();
                        break;
                    }
                    case 7: {
                        dateFormat = ODateHelper.getDateTimeFormatInstance();
                        break;
                    }
                }
                return new TextNode(dateFormat.format((Date)object));
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                objectMapper = new ObjectMapper();
                ArrayNode arrayNode = objectMapper.createArrayNode();
                for (Object o : collection) {
                    JsonNode obj = this.getPropertyForJson("PLACEHOLDER", o);
                    if (obj == null) continue;
                    arrayNode.add(obj);
                }
                return arrayNode;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                objectMapper = new ObjectMapper();
                ObjectNode objectNode = objectMapper.createObjectNode();
                for (String k : map.keySet()) {
                    JsonNode obj = this.getPropertyForJson("PLACEHOLDER", map.get(k));
                    objectNode.set(k, obj);
                }
                return objectNode;
            }
            if (object instanceof Boolean) {
                return BooleanNode.valueOf((boolean)((Boolean)object));
            }
            return new TextNode(object.toString());
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + key + "=" + object.toString() + " in " + this.getElement().toString(), (Throwable)e);
        }
    }

    protected String getNotNullErrorMessage(String fieldName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The type ");
        stringBuffer.append(this.typeName);
        stringBuffer.append(" defines the fields ");
        stringBuffer.append(fieldName);
        stringBuffer.append(" as not nullable. Null or no value has been provided instead.");
        return stringBuffer.toString();
    }

    protected String getMandatoryErrorMessage(String fieldName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The type ");
        stringBuffer.append(this.typeName);
        stringBuffer.append(" defines the fields ");
        stringBuffer.append(fieldName);
        stringBuffer.append(" as mandatory but no value has been provided.");
        return stringBuffer.toString();
    }

    protected boolean typeSatified(TypesCache typesCache, String requiredType, String effectiveType) throws SchemaException, ResourceRegistryException {
        if (requiredType.compareTo(effectiveType) == 0) {
            return true;
        }
        CachedType cachedType = typesCache.getCachedType(requiredType);
        return cachedType.getSubTypes().contains(effectiveType);
    }

    protected Set<PropertyDefinition> getAllProperties() throws SchemaException, ResourceRegistryException {
        TypesCache typesCache = TypesCache.getInstance();
        Set definedProperties = this.getCachedType().getType().getProperties();
        HashSet<CachedType> cachedSuperTypes = new HashSet<CachedType>();
        List superTypes = this.cachedType.getSuperTypes();
        for (String superTypeName : superTypes) {
            CachedType cachedSuperType = typesCache.getCachedType(superTypeName);
            cachedSuperTypes.add(cachedSuperType);
            Type superType = cachedSuperType.getType();
            Set properties = superType.getProperties();
            if (properties == null) continue;
            definedProperties.addAll(properties);
        }
        return definedProperties;
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
        if (this.operation.isSafe()) {
            return;
        }
        Set definedProperties = this.getAllProperties();
        if (definedProperties == null) {
            return;
        }
        Set elementPropertyNames = this.getElement().getPropertyNames();
        for (PropertyDefinition propertyDefinition : definedProperties) {
            String fieldName = propertyDefinition.getName();
            if (!propertyDefinition.isMandatory() || elementPropertyNames.contains(fieldName)) continue;
            if (propertyDefinition.isNotnull()) {
                this.element.setProperty(fieldName, null);
                continue;
            }
            throw new SchemaViolationException(this.getMandatoryErrorMessage(fieldName));
        }
    }
}

